package dyte.io.uikit.atoms

import android.content.Context
import android.util.AttributeSet
import com.google.android.material.textview.MaterialTextView
import dyte.io.uikit.designtokens.TokenRepo
import dyte.io.uikit.tokens
import dyte.io.uikit.wiptoken.DyteUITokens

class DyteLabelAtom : MaterialTextView {
  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    refresh(tokens)
  }

  fun refresh(token: DyteUITokens = tokens) {
    setTextColor(token.colors.text.onBackground.shade1000)
    val fontSize = TokenRepo.getFontSizeRepo().getFontSize()
    textSize = fontSize
  }
}