package dyte.io.uikit.atoms

import android.content.Context
import android.graphics.Typeface
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import dyte.io.uikit.tokens
import dyte.io.uikit.wiptoken.DyteUITokens

class DytePeerInitialsTextView : androidx.appcompat.widget.AppCompatTextView {
  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  fun init() {
    refresh(tokens)
  }

  fun refresh(uiTokens: DyteUITokens) {

    val shape = GradientDrawable()
    // Todo: Check with design team if this refers the border-radius token
    // shape.cornerRadius = TokenRepo.getBorderRadiusRepo().getBorderRadius(999).px.toFloat()
    shape.cornerRadius = 9999f

    shape.setColor(uiTokens.colors.brand.shade500)

    // Todo: Check with design team if this refers the border-width token
    // val strokeColor = TokenRepo.getColorRepo().getBrandColor()
    // shape.setStroke(
    //   TokenRepo.getBorderWidthRepo().getBorderWidth(10).px.toFloat().toInt(),
    //   strokeColor
    // )

    background = shape
    setTextColor(uiTokens.colors.text.onBackground.shade1000)
    typeface = Typeface.DEFAULT_BOLD
  }
}