package dyte.io.uikit.atoms

import android.content.Context
import android.graphics.Typeface
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatTextView
import androidx.core.content.ContextCompat
import androidx.core.graphics.drawable.DrawableCompat
import dyte.io.uikit.R
import dyte.io.uikit.tokens
import dyte.io.uikit.wiptoken.DyteUITokens

open class DyteTagTextView: AppCompatTextView {
  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  fun init() {
    refresh(tokens)
  }

  open fun refresh(uiTokens: DyteUITokens) {
    val shape = GradientDrawable()
    shape.setColor(uiTokens.colors.background.shade900)
    shape.cornerRadius = 5f
    setPadding(20, 10, 20, 10)
    background = shape

    val drawable = ContextCompat.getDrawable(context, R.drawable.ic_plugin_24)
    DrawableCompat.setTint(requireNotNull(drawable), uiTokens.colors.text.onBackground.shade1000)
    setCompoundDrawablesWithIntrinsicBounds(drawable, null, null, null)
    compoundDrawablePadding = 10

    setTextColor(uiTokens.colors.text.onBackground.shade1000)
    typeface = Typeface.DEFAULT_BOLD

    setUnSelected()
  }

  fun setSelected() {
    val shape = GradientDrawable()
    shape.setColor(tokens.colors.brand.shade500)
    shape.cornerRadius = 5f
    setPadding(20, 10, 20, 10)
    background = shape
  }

  fun setUnSelected() {
    val shape = GradientDrawable()
    shape.setColor(tokens.colors.background.shade900)
    shape.cornerRadius = 5f
    setPadding(20, 10, 20, 10)
    background = shape
  }
}