package dyte.io.uikit.designtokens

import dyte.io.uikit.designtokens.BorderRadiusType.CIRCULAR
import dyte.io.uikit.designtokens.BorderRadiusType.EXTRA_ROUNDED
import dyte.io.uikit.designtokens.BorderRadiusType.ROUNDED
import dyte.io.uikit.designtokens.BorderRadiusType.SHARP

enum class BorderRadiusType {
  SHARP,
  ROUNDED,
  EXTRA_ROUNDED,
  CIRCULAR;
}

class BorderRadiusRepo(private val designToken: DyteDesignToken) : BorderRadiusRepoType {
  override fun getBorderRadius(radius: Int): Int {
    return when (designToken.borderRadiusType) {
      SHARP -> 0 * radius
      ROUNDED -> 4 * radius
      EXTRA_ROUNDED -> 8 * radius
      CIRCULAR -> 999 * radius
    }
  }
}

interface BorderRadiusRepoType {
  fun getBorderRadius(radius: Int): Int
}