package dyte.io.uikit.designtokens

import android.graphics.Color
import android.util.Log
import androidx.annotation.ColorInt

/**
 * used to get background color from color name
 */
class ColorRepo(private val designToken: DyteDesignToken) : ColorRepoType {
  private val defaultBgColorNameToCodes = hashMapOf(
    "color-bg-1000" to "#080808",
    "color-bg-900" to "#1A1A1A",
    "color-bg-800" to "#333333",
    "color-bg-700" to "#4c4c4c",
    "color-bg-600" to "#666666"
  )

  private val defaultBrandColorNameToCodes = hashMapOf(
    "color-brand-700" to "#0246FD",
    "color-brand-600" to "#0D51FD",
    "color-brand-500" to "#2160FD",
    "color-brand-400" to "#356EFD",
    "color-brand-300" to "#497CFD"
  )

  private val colorTextOnBg = "#FFFFFF"
  private val defaultTextColorOnBgToCodes = hashMapOf(
    "color-text-on-bg-1000" to "#FFFFFFFF",
    "color-text-on-bg-900" to "#E0FFFFFF",
    "color-text-on-bg-800" to "#C2FFFFFF",
    "color-text-on-bg-700" to "#A3FFFFFF",
    "color-text-on-bg-600" to "#85FFFFFF"
  )

  private val colorTextOnBrand = "#FFFFFF"
  private val defaultTextColorOnBrandToCodes = hashMapOf(
    "color-text-on-bg-1000" to "#FF111111",
    "color-text-on-bg-900" to "#E0111111",
    "color-text-on-bg-800" to "#C2111111",
    "color-text-on-bg-700" to "#A3111111",
    "color-text-on-bg-600" to "#85111111"
  )
  private val defaultVideoBgNameToCodes = hashMapOf(
    "color-video-bg-500" to "#1E1E1E",
  )

  private val statusColorDanger = "#FF2D2D"
  private val statusColorSuccess = "#83D017"
  private val statusColorWarning = "#FFCD07"
  private val settingColorBg = "#2C2C2C"
  private val nameTagBackground = "#262626"

  @ColorInt
  override fun getBackgroundColor(): Int {
    return Color.parseColor(defaultBgColorNameToCodes[designToken.defaultBgColor])
  }

  @ColorInt
  override fun getBrandColor(): Int {
    return Color.parseColor(defaultBrandColorNameToCodes[designToken.defaultBrandColor])
  }

  @ColorInt
  override fun getTextColorOnBg(): Int {
    return Color.parseColor(defaultTextColorOnBgToCodes[designToken.defaultTextColorOnBg])
  }

  @ColorInt
  override fun getTextColorOnBrand(): Int {
    return Color.parseColor(colorTextOnBrand)
  }

  @ColorInt
  override fun getStatusColorDanger(): Int {
    return Color.parseColor(statusColorDanger)
  }

  @ColorInt
  override fun getStatusColorSuccess(): Int {
    return Color.parseColor(statusColorSuccess)
  }

  @ColorInt
  override fun getStatusColorWarning(): Int {
    return Color.parseColor(statusColorWarning)
  }

  override fun getVideoBackGroundColor(): Int {
    return Color.parseColor(defaultVideoBgNameToCodes[designToken.defaultVideoBackground])
  }

  override fun getNameTagColor(): Int {

    return Color.parseColor(nameTagBackground)
  }

  override fun getSettingViewBackground(): Int {
    return Color.parseColor(settingColorBg)
  }

  override fun getIconColor(): Int {
    return Color.parseColor(defaultTextColorOnBgToCodes[designToken.iconColor])
  }
}

interface ColorRepoType {
  @ColorInt
  fun getBackgroundColor(): Int

  @ColorInt
  fun getBrandColor(): Int

  @ColorInt
  fun getIconColor(): Int

  @ColorInt
  fun getTextColorOnBg(): Int

  @ColorInt
  fun getTextColorOnBrand(): Int

  @ColorInt
  fun getStatusColorDanger(): Int

  @ColorInt
  fun getStatusColorSuccess(): Int

  @ColorInt
  fun getStatusColorWarning(): Int

  @ColorInt
  fun getVideoBackGroundColor(): Int

  @ColorInt
  fun getNameTagColor(): Int

  @ColorInt
  fun getSettingViewBackground(): Int
}