package dyte.io.uikit.designtokens

class LineHeightRepo : LineHeightRepoType {

  private val lineHeightTokenToLineHeight = hashMapOf(
    "line-height-150" to 1.5F,
    "line-height-125" to 1.25F,
    "line-height-100" to 1F
  )

  override fun getLineHeight(token: String): Float {
    return lineHeightTokenToLineHeight[token] ?: 1F
  }
}

interface LineHeightRepoType {
  fun getLineHeight(token: String): Float
}