package dyte.io.uikit.designtokens

import dyte.io.uikit.designtokens.BorderRadiusType.ROUNDED
import dyte.io.uikit.designtokens.BorderWidthType.THIN

@Deprecated("use DyteUITokens from WIPtoken")
object TokenRepo : TokenRepoType {
  private lateinit var borderRadiusRepo: BorderRadiusRepoType
  private lateinit var borderWidthRepo: BorderWidthRepoType
  private lateinit var spacingRepo: SpacingRepoType
  private lateinit var colorRepo: ColorRepoType
  private lateinit var fontSizeRepo: FontSizeRepoType
  private lateinit var fontStyleRepo: FontStyleRepoType

  private var dyteDesignToken: DyteDesignToken

  init {
    dyteDesignToken = DyteDesignToken()
  }

  override fun getBorderWidthRepo(): BorderWidthRepoType {
    if (!this::borderWidthRepo.isInitialized) {
      borderWidthRepo = BorderWidthRepo(dyteDesignToken)
    }
    return borderWidthRepo
  }

  override fun getBorderRadiusRepo(): BorderRadiusRepoType {
    if (!this::borderRadiusRepo.isInitialized) {
      borderRadiusRepo = BorderRadiusRepo(dyteDesignToken)
    }
    return borderRadiusRepo
  }

  override fun getColorRepo(): ColorRepoType {
    if (!this::colorRepo.isInitialized) {
      colorRepo = ColorRepo(dyteDesignToken)
    }
    return colorRepo
  }

  override fun getSpacingRepo(): SpacingRepoType {
    if (!this::spacingRepo.isInitialized) {
      spacingRepo = SpacingRepo(dyteDesignToken)
    }
    return spacingRepo
  }

  override fun getFontSizeRepo(): FontSizeRepoType {
    if (!this::fontSizeRepo.isInitialized) {
      fontSizeRepo = FontSizeRepo(dyteDesignToken)
    }
    return fontSizeRepo
  }

  override fun getFontStyleRepo(): FontStyleRepoType {
    if (!this::fontStyleRepo.isInitialized) {
      fontStyleRepo = FontStyleRepo(dyteDesignToken)
    }
    return fontStyleRepo
  }

  override fun setDesignToken(designToken: DyteDesignToken) {
    dyteDesignToken = designToken
  }

  override fun getDesignToken(): DyteDesignToken {
    return dyteDesignToken
  }
}

data class DyteDesignToken(
  val borderWidthType: BorderWidthType = THIN,
  val borderRadiusType: BorderRadiusType = ROUNDED,
  val iconColor: String = "color-text-on-bg-1000",
  val spacing: Int = 1,
  val defaultBgColor: String = "color-bg-900",
  val defaultBrandColor: String = "color-brand-500",
  val defaultTextColorOnBg: String = "color-text-on-bg-1000",
  val defaultTextColorOnBrand: String = "color-text-on-bg-1000",
  val fontSize: String = "font-size-100",
  val fontStyle: String = "font-style-regular",
  val defaultVideoBackground: String = "color-video-bg-500"
)

@Deprecated("dont use me!")
interface TokenRepoType {
  fun getBorderWidthRepo(): BorderWidthRepoType
  fun getBorderRadiusRepo(): BorderRadiusRepoType
  fun getColorRepo(): ColorRepoType
  fun getSpacingRepo(): SpacingRepoType
  fun getFontSizeRepo(): FontSizeRepoType
  fun getFontStyleRepo(): FontStyleRepoType

  fun setDesignToken(designToken: DyteDesignToken)
  fun getDesignToken(): DyteDesignToken
}