package dyte.io.uikit.molecules

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.Window
import androidx.constraintlayout.widget.ConstraintLayout
import dyte.io.uikit.DyteUIKitBuilder
import dyte.io.uikit.R
import dyte.io.uikit.atoms.DyteButton
import dyte.io.uikit.atoms.DyteIconView
import dyte.io.uikit.atoms.DyteLabelAtom
import dyte.io.uikit.tokens
import dyte.io.uikit.utils.Utils.px
import dyte.io.uikit.utils.ViewUtils.gone
import dyte.io.uikit.utils.ViewUtils.setBackground
import dyte.io.uikit.utils.ViewUtils.visible
import dyte.io.uikit.wiptoken.BorderRadiusToken
import kotlinx.coroutines.launch

class DyteLeaveCallDialog(context: Context) : Dialog(context) {
  private lateinit var dlaTitle: DyteLabelAtom
  private lateinit var dlaMessage: DyteLabelAtom
  private lateinit var dbCancel: DyteButton
  private lateinit var dbLeave: DyteButton
  private lateinit var dbEndCall: DyteButton
  private lateinit var divClose: DyteIconView
  private lateinit var clDialogContainer: ConstraintLayout

  override fun onCreate(savedInstanceState: Bundle?) {
    super.onCreate(savedInstanceState)
    requestWindowFeature(Window.FEATURE_NO_TITLE)
    setContentView(R.layout.dialog_leave_call)

    clDialogContainer = findViewById(R.id.clDialogContainer)
    clDialogContainer.setBackground(BorderRadiusToken.Sharp, tokens.colors.background.shade900)

    dlaTitle = findViewById(R.id.dlaTitle)
    dlaMessage = findViewById(R.id.dlaMessage)
    dbCancel = findViewById(R.id.dbCancel)
    dbLeave = findViewById(R.id.dbEndCall)
    divClose = findViewById(R.id.divClose)
    dbEndCall = findViewById(R.id.dbEndCallAll)

    dlaMessage.setTextColor(tokens.colors.text.onBackground.shade1000)
    dlaTitle.setTextColor(tokens.colors.text.onBackground.shade1000)
    dlaTitle.textSize = 8.px.toFloat()

    dbCancel.setBackground(tokens.borderRadius, tokens.colors.background.shade800)
    dbLeave.setBackground(tokens.borderRadius, tokens.colors.status.danger)
    dbEndCall.setBackground(tokens.borderRadius, tokens.colors.status.danger)

    divClose.setOnClickListener {
      dismiss()
    }

    dbLeave.setOnClickListener {
      DyteUIKitBuilder.dyteUIKit.meeting.leaveRoom()
      dismiss()
    }

    dbCancel.setOnClickListener {
      dismiss()
    }

    if (DyteUIKitBuilder.dyteUIKit.meeting.localUser.permissions.host.canKickParticipant) {
      dbEndCall.visible()
      dbEndCall.setOnClickListener {
        DyteUIKitBuilder.dyteUIKit.meeting.participants.kickAll()
        DyteUIKitBuilder.dyteUIKit.meeting.leaveRoom()
        dismiss()
      }
    } else {
      dbEndCall.gone()
    }
  }
}