package dyte.io.uikit.molecules

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.cardview.widget.CardView
import coil.load
import coil.transform.CircleCropTransformation
import dyte.io.uikit.R
import dyte.io.uikit.atoms.DytePeerInitialsTextView
import dyte.io.uikit.tokens
import dyte.io.uikit.utils.Utils
import dyte.io.uikit.utils.ViewUtils.gone
import dyte.io.uikit.utils.ViewUtils.visible
import dyte.io.uikit.utils.displayDensity
import dyte.io.uikit.view.DytePeerNameTag
import dyte.io.uikit.wiptoken.BorderRadiusToken.BorderRadiusSize
import io.dyte.core.feat.DyteMeetingParticipant
import io.dyte.core.listeners.DyteParticipantUpdateListener

class DyteVideoPeer : LinearLayout {
  private lateinit var tvInitials: DytePeerInitialsTextView
  private lateinit var tvName: DytePeerNameTag
  private lateinit var ivImage: ImageView
  private lateinit var cvVideoContainer: CardView
  private lateinit var flVideoContainer: RelativeLayout

  private lateinit var participantUpdateListener: DyteParticipantUpdateListener
  private lateinit var participant: DyteMeetingParticipant

  constructor(context: Context) : super(context) {
    init(context)
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init(context)
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init(context)
  }

  private fun init(context: Context) {
    val view = inflate(context, R.layout.view_video_peer, this)

    flVideoContainer = view.findViewById(R.id.selfVideoRenderer)
    tvInitials = view.findViewById(R.id.tvSelfInitials)
    tvName = view.findViewById(R.id.tvName)
    ivImage = view.findViewById(R.id.ivPeerImageView)
    cvVideoContainer = view.findViewById(R.id.cvVideoContainer)

    applyUITokens()
  }

  // Todo: add support for border-width token
  // TODO : pass
  private fun applyUITokens() {
    cvVideoContainer.radius =
      tokens.borderRadius.getRadius(BorderRadiusSize.TWO, displayDensity)
    cvVideoContainer.setCardBackgroundColor(tokens.colors.videoBackground)
  }

  fun refresh(participant: DyteMeetingParticipant) {
    this.participant = participant
    tvName.refresh(participant)

    refreshName()
    render(participant)
    participantUpdateListener = object: DyteParticipantUpdateListener {
      override fun onVideoUpdate(isEnabled: Boolean) {
        super.onVideoUpdate(isEnabled)
        render(participant)
      }
    }

    val nameInitials = Utils.getInitialsFromName(participant.name)
    tvInitials.visibility = View.VISIBLE
    tvInitials.text = nameInitials
    participant.addParticipantUpdateListener(participantUpdateListener)
  }

  fun refreshName() {
    if (participant.name.isNotEmpty()) {
      refreshPlaceholder()
    } else {
      tvInitials.visibility = View.GONE
    }
    tvName.refresh(participant)
  }

  private fun refreshPlaceholder() {
    println("DyteMobileClient | DyteVideoPeer refreshPlaceholder ")
    if(participant.videoEnabled) {
      println("DyteMobileClient | DyteVideoPeer refreshPlaceholder video is enabled")
      return
    }
    if (participant.picture?.isNotEmpty() == true) {
      println("DyteMobileClient | DyteVideoPeer refreshPlaceholder we've image")
      ivImage.visible()
      ivImage.load(participant.picture) {
        transformations(CircleCropTransformation())
      }
      tvInitials.gone()
    } else {
      println("DyteMobileClient | DyteVideoPeer refreshPlaceholder no image")
      val nameInitials = Utils.getInitialsFromName(participant.name)
      tvInitials.visible()
      tvInitials.text = nameInitials
    }
  }

  private fun render(participant: DyteMeetingParticipant) {
    println("DyteMobileClient | DyteVideoPeer render ${participant.name} ${participant.videoEnabled} ${participant.audioEnabled}")
    val videoView = participant.getVideoView()
    if (participant.videoEnabled && participant.videoTrack != null) {
      flVideoContainer.removeAllViews()
      (videoView?.parent as? ViewGroup)?.removeView(videoView)
      flVideoContainer.addView(videoView)
      videoView?.renderVideo()
      flVideoContainer.visible()
    } else {
      flVideoContainer.gone()
    }
    refreshPlaceholder()
  }

  override fun onViewRemoved(child: View?) {
    super.onViewRemoved(child)
    println("DyteMobileClient | DyteVideoPeer onViewRemoved ${participant.name}")
    participant.removeParticipantUpdateListener(participantUpdateListener)
    flVideoContainer.removeAllViews()
  }
}