package dyte.io.uikit.molecules.dytegrid

import dyte.io.uikit.DyteUIKitBuilder
import dyte.io.uikit.molecules.dytegrid.GridPage.GridAutoPage
import dyte.io.uikit.molecules.dytegrid.GridPage.GridPeersPage

class GridHelper {
  private val meeting by lazy {
    DyteUIKitBuilder.meeting
  }

  fun getPages() : List<GridPage> {
    val pages = arrayListOf<GridPage>()

    val screenSharePeers = meeting.participants.screenshares
    val plugins = meeting.plugins.active
    val roomParticipants = meeting.participants

    if (screenSharePeers.isNotEmpty() || plugins.isNotEmpty()) {
      println("DyteMobileClient | GridHelper adding screenshare and plugin page")
      pages.add(GridAutoPage)
      pages.add(GridPeersPage)
    } else {
      println("DyteMobileClient | GridHelper getPages no screen share and plugin")
      if (roomParticipants.pageCount == 1) {
        println("DyteMobileClient | GridHelper getPages add manaual peer page")
        pages.add(GridPeersPage)
      }
    }

    /*for (page in 1 until  pageInfo.pageCount) {
      println("DyteMobileClient | GridHelper peer pages $page")
      pages.add(GridPeersPage)
    }*/

    println("DyteMobileClient | GridHelper getPages $pages")
    return pages
  }
}

sealed class GridPage {
  object GridAutoPage: GridPage()
  object GridPeersPage: GridPage()
}