package dyte.io.uikit.screens.chat

import android.content.Context
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.widget.ImageView
import androidx.appcompat.widget.AppCompatImageButton
import coil.load
import dyte.io.uikit.R

class DyteImageViewerActivity : AppCompatActivity() {
  override fun onCreate(savedInstanceState: Bundle?) {
    super.onCreate(savedInstanceState)
    setContentView(R.layout.activity_dyte_image_viewer)
    findViewById<ImageView>(R.id.image_viewer_image_view).load(intent.getImageUrl())
    findViewById<AppCompatImageButton>(R.id.image_viewer_button_close).setOnClickListener {
      finish()
    }
  }

  companion object {
    private const val KEY_IMAGE_URL = "image_url"

    fun getIntent(context: Context, imageUrl: String): Intent {
      return Intent(context, DyteImageViewerActivity::class.java).apply {
        putExtra(KEY_IMAGE_URL, imageUrl)
      }
    }

    private fun Intent.getImageUrl(): String {
      return extras?.getString(KEY_IMAGE_URL) ?: error("Image URL must be passed")
    }
  }
}