package dyte.io.uikit.screens.meeting

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleEventObserver
import androidx.lifecycle.LifecycleObserver
import androidx.lifecycle.ViewModelProvider
import dyte.io.uikit.R
import dyte.io.uikit.molecules.dytegrid.DyteGridView
import dyte.io.uikit.screens.meetingoptions.DyteMeetingOptionBottomSheet
import dyte.io.uikit.atoms.DyteCameraToggleButton
import dyte.io.uikit.molecules.DyteLeaveCallDialog
import dyte.io.uikit.view.DyteControlBarView
import dyte.io.uikit.molecules.DyteMeetingHeaderView
import dyte.io.uikit.tokens
import dyte.io.uikit.utils.ViewUtils.gone
import dyte.io.uikit.utils.ViewUtils.visible
import dyte.io.uikit.view.DyteLeaveButton
import dyte.io.uikit.view.DyteLiveStreamToggleButton
import dyte.io.uikit.view.DyteMicToggleButton
import dyte.io.uikit.view.DyteMoreToggleButton
import dyte.io.uikit.wiptoken.DyteUITokens
import io.dyte.core.DyteMobileClient

class DyteGroupCallFragment : Fragment() {
  private lateinit var gridView: DyteGridView

  private lateinit var headerView: DyteMeetingHeaderView
  private lateinit var controlBarView: DyteControlBarView
  private lateinit var micToggleButton: DyteMicToggleButton
  private lateinit var cameraToggleButton: DyteCameraToggleButton
  private lateinit var moreToggleButton: DyteMoreToggleButton
  private lateinit var leaveButton: DyteLeaveButton
  private lateinit var liveStreamToggleButton: DyteLiveStreamToggleButton

  private lateinit var viewModel: DyteGroupCallViewModel

  override fun onCreateView(
    inflater: LayoutInflater, container: ViewGroup?,
    savedInstanceState: Bundle?
  ): View? {
    return inflater.inflate(R.layout.fragment_dyte_group_call, container, false)
  }

  override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
    super.onViewCreated(view, savedInstanceState)

    gridView = view.findViewById(R.id.llGridView)

    headerView = view.findViewById(R.id.dyteheaderview_meeting_screen)
    controlBarView = view.findViewById(R.id.dytecontrolbarview_meeting_screen)
    micToggleButton = view.findViewById(R.id.dytemictoggle_meeting_screen)
    cameraToggleButton = view.findViewById(R.id.dytecameratoggle_meeting_screen)
    moreToggleButton = view.findViewById(R.id.dytemoretoggle_meeting_screen)
    leaveButton = view.findViewById(R.id.dyteleavebutton_meeting_screen)
    liveStreamToggleButton = view.findViewById(R.id.dytelivestreamtoggle_meeting_screen)

    viewModel = ViewModelProvider(this)[DyteGroupCallViewModel::class.java]

    moreToggleButton.setOnClickListener {
      val dyteMeetingOptionBottomSheet = DyteMeetingOptionBottomSheet()
      dyteMeetingOptionBottomSheet.show(
        childFragmentManager,
        DyteGroupCallFragment::class.java.simpleName
      )
      dyteMeetingOptionBottomSheet.lifecycle
        .addObserver(LifecycleEventObserver { source, event ->
          if (event === Lifecycle.Event.ON_DESTROY) {
            gridView.refreshSelf()
          }
        } as LifecycleObserver)
    }

    leaveButton.setOnClickListener {
      val endCallDialog = DyteLeaveCallDialog(requireContext())
      endCallDialog.show()
    }

    applyUiTokens()
    bindMeetingToChildComponents(viewModel.meeting)

    if (viewModel.shouldShowLiveStreamButton()) {
      liveStreamToggleButton.visible()
    } else {
      liveStreamToggleButton.gone()
    }

    gridView.refresh()
  }

  private fun applyUiTokens(uiTokens: DyteUITokens = tokens) {
    headerView.applyUiTokens(uiTokens)
    controlBarView.applyUiTokens(uiTokens)
  }

  private fun bindMeetingToChildComponents(meeting: DyteMobileClient) {
    headerView.activate(meeting)
    micToggleButton.activate(meeting)
    cameraToggleButton.activate(meeting)
    liveStreamToggleButton.activate(meeting)
  }
}