package dyte.io.uikit.screens.participant

import io.dyte.core.feat.DyteMeetingParticipant

sealed class UiParticipantPlank(val viewType: Int) {
  class Lable(val label: String) : UiParticipantPlank(0)
  class WaitListed(val participant: UiParticipant) : UiParticipantPlank(1)
  object AcceptAll : UiParticipantPlank(2)
  class Joined(val participant: UiParticipant) : UiParticipantPlank(3)
  object SearchBox: UiParticipantPlank(4)
}

data class UiParticipant (
  val id: String,
  val name: String,
  val photo: String?,
  val audioEnabled: Boolean,
  val videoEnabled: Boolean,
  val dyteMeetingParticipant: DyteMeetingParticipant,
  val isLast: Boolean = false
  )