package dyte.io.uikit.screens.plugins

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.ListAdapter
import androidx.recyclerview.widget.RecyclerView
import coil.load
import dyte.io.uikit.R
import io.dyte.core.feat.DytePlugin

class PluginListAdapter(
  private val onActivatePluginClick: (DytePlugin) -> Unit
) : ListAdapter<DytePlugin, PluginListAdapter.PluginViewHolder>(PluginDiffCallback()) {

  override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): PluginViewHolder {
    val view = LayoutInflater.from(parent.context)
      .inflate(R.layout.list_item_plugin, parent, false)
    return PluginViewHolder(view, onActivatePluginClick)
  }

  override fun onBindViewHolder(holder: PluginViewHolder, position: Int) {
    holder.bind(getItem(position))
  }

  inner class PluginViewHolder(
    itemView: View,
    private val onActivatePluginClick: (DytePlugin) -> Unit
  ) : RecyclerView.ViewHolder(itemView) {
    private val nameTextView: TextView =
      itemView.findViewById(R.id.plugin_text_view_name)
    private val iconImageView: ImageView = itemView.findViewById(R.id.plugin_image_view_icon)
    private val activatePluginImageView: ImageView =
      itemView.findViewById(R.id.plugin_image_view_activate)

    fun bind(plugin: DytePlugin) {
      nameTextView.text = plugin.name
      iconImageView.load(plugin.picture)
      with(activatePluginImageView) {
        setOnClickListener { onActivatePluginClick(plugin) }
        if (plugin.isActive) {
          setImageResource(R.drawable.ic_close_24)
        } else {
          setImageResource(R.drawable.ic_plugin_24)
        }
      }
    }
  }
}

private class PluginDiffCallback : DiffUtil.ItemCallback<DytePlugin>() {
  override fun areItemsTheSame(oldItem: DytePlugin, newItem: DytePlugin): Boolean {
    return oldItem.id == newItem.id
  }

  override fun areContentsTheSame(oldItem: DytePlugin, newItem: DytePlugin): Boolean {
    return oldItem.isActive == newItem.isActive
  }
}