package dyte.io.uikit.view

import android.content.Context
import android.util.AttributeSet
import android.view.Gravity
import android.view.View
import android.widget.Space
import androidx.appcompat.widget.LinearLayoutCompat
import dyte.io.uikit.tokens
import dyte.io.uikit.wiptoken.DyteUITokens

class DyteControlBarView : LinearLayoutCompat {
  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, uiTokens: DyteUITokens) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    gravity = Gravity.CENTER
    applyUiTokens()
  }

  fun applyUiTokens(uiTokens: DyteUITokens = tokens) {
    setBackgroundColor(uiTokens.colors.background.shade900)
    for (i in 0 until childCount) {
      if (getChildAt(i) is DyteControlBarButton) {
        (getChildAt(i) as DyteControlBarButton).applyUiTokens(uiTokens)
      }
    }
  }

  override fun addView(child: View?, index: Int, params: android.view.ViewGroup.LayoutParams?) {
    if (child is DyteControlBarButton?) {
      if (childCount > 0) {
        val interSpace = Space(context)
        val interSpaceLayoutParams = LinearLayoutCompat.LayoutParams(0, 0).apply {
          weight = 1f
        }
        super.addView(interSpace, index, interSpaceLayoutParams)
      }
      super.addView(child, -1, params)
    }
  }
}