package dyte.io.uikit.view

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import android.widget.ImageView
import android.widget.LinearLayout
import dyte.io.uikit.DyteUIKitBuilder
import dyte.io.uikit.R
import dyte.io.uikit.atoms.DyteLabelAtom
import dyte.io.uikit.designtokens.TokenRepoType
import dyte.io.uikit.tokens
import dyte.io.uikit.utils.Utils.px
import dyte.io.uikit.utils.ViewUtils.gone
import dyte.io.uikit.utils.ViewUtils.visible
import dyte.io.uikit.utils.displayDensity
import dyte.io.uikit.wiptoken.BorderRadiusToken.BorderRadiusSize
import dyte.io.uikit.wiptoken.DyteUITokens
import io.dyte.core.DyteMobileClient
import io.dyte.core.controllers.GridInfo
import io.dyte.core.listeners.DyteParticipantEventsListener
import io.dyte.core.models.DyteRoomParticipants

class DyteGridPaginatorView : LinearLayout {
  private lateinit var ivNext: ImageView
  private lateinit var ivPrev: ImageView

  private lateinit var tvPages: DyteLabelAtom
  private lateinit var llPaginatorContainer: LinearLayout

  private val participantEventListener = object : DyteParticipantEventsListener {
    override fun onUpdate(participants: DyteRoomParticipants) {
      super.onUpdate(participants)
      refresh()
    }
  }

  constructor(context: Context) : super(context) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?
  ) : super(context, attrs) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?,
    defStyleAttr: Int
  ) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    inflate(context, R.layout.grid_paginator, this)

    ivNext = findViewById(R.id.ivNext)
    ivPrev = findViewById(R.id.ivPrev)
    tvPages = findViewById(R.id.tvPages)
    llPaginatorContainer = findViewById(R.id.llPaginatorContainer)
  }

  fun refresh(
    dyteAndroidClient: DyteMobileClient,
    uiTokens: DyteUITokens = tokens
  ) {
    dyteAndroidClient.addParticipantEventsListener(participantEventListener)

    val backgroundDrawable = GradientDrawable().apply {
      shape = GradientDrawable.RECTANGLE
      setColor(uiTokens.colors.background.shade700)
      cornerRadius = uiTokens.borderRadius.getRadius(BorderRadiusSize.ONE, displayDensity)
    }
    llPaginatorContainer.background = backgroundDrawable
    /*val shape = GradientDrawable()
    shape.cornerRadius = tokenRepo.getBorderRadiusRepo().getBorderRadius(999).px.toFloat()

    shape.setColor(tokenRepo.getColorRepo().getBrandColor())

    val strokeColor = tokenRepo.getColorRepo().getBrandColor()
    shape.setStroke(
      tokenRepo.getBorderWidthRepo().getBorderWidth(2).px.toFloat().toInt(),
      strokeColor
    )

    llPaginatorContainer.background = shape*/
    ivNext.setOnClickListener {
      dyteAndroidClient.participants.setPage(dyteAndroidClient.participants.currentPageNumber+1)
    }

    ivPrev.setOnClickListener {
      dyteAndroidClient.participants.setPage(dyteAndroidClient.participants.currentPageNumber-1)
    }

    tvPages.text = "${DyteUIKitBuilder.meeting.participants.currentPageNumber.plus(1)}/${DyteUIKitBuilder.meeting.participants.pageCount}"
  }

  private fun refresh() {
    ivNext.isEnabled = DyteUIKitBuilder.meeting.participants.canGoNextPage
    ivPrev.isEnabled =DyteUIKitBuilder.meeting.participants.canGoPreviousPage
    tvPages.text = "${DyteUIKitBuilder.meeting.participants.currentPageNumber.plus(1)}/${DyteUIKitBuilder.meeting.participants.pageCount}"
    tvPages.textSize = 16f
  }
}