package dyte.io.uikit.view

/**
 * Dyte image button
 *
 * Used by [dyte.io.uikit.components.DyteIconButtonView] to render respective button on screen
 * This sealed class is also responsible to host state associated given button.
 * Example, AudioToggle button will have state weather audio is muted or not
 *
 * @property name
 * @constructor Create empty Dyte image button
 */
sealed class DyteIconButtonType(val name: String) {
  object PARTICIPANT_LIST : DyteIconButtonType("PARTICIPANT_LIST")
  object CHAT : DyteIconButtonType("CHAT")
  object PLUGINS : DyteIconButtonType("PLUGINS")
  object SWITCH_CAMERA : DyteIconButtonType("SWITCH_CAMERA")
  class AudioToggle(var isAudioMuted: Boolean) : DyteIconButtonType("AUDIO_TOGGLE")
  class VideoToggle(var isVideoMuted: Boolean) : DyteIconButtonType("VIDEO_TOGGLE")
  object SETTINGS : DyteIconButtonType("SETTINGS")
  object AUDIO_TRACK_SELECTOR : DyteIconButtonType("AUDIO_TRACK_SELECTOR")
  object SCREEN_SHARE : DyteIconButtonType("SCREEN_SHARE")
  object END_CALL : DyteIconButtonType("END_CALL")
  object OPEN_OPTION : DyteIconButtonType("OPEN_OPTION")
}