package dyte.io.uikit.view

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import android.view.Gravity
import android.widget.ImageView
import android.widget.ImageView.ScaleType.CENTER
import android.widget.LinearLayout
import dyte.io.uikit.R
import dyte.io.uikit.designtokens.TokenRepo
import dyte.io.uikit.utils.Utils.px

/**
 * Dyte icon button view
 *
 * Android View implementation to render [MeetingComponent.IconButton]
 * Depending on type of button renders appropriate view on ImageView.
 * Also adds a click listener and performs action depending upon [dyte.io.uikit.DyteIconButtonType]
 *
 * Shown to image view type buttons.
 * Click is also handelled here only.
 */
class DyteIconMoreOptionView : LinearLayout {

  lateinit var ivLogo: ImageView
  lateinit var llImageButtonContainer: LinearLayout

  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    inflate(context, R.layout.send_view, this)
    ivLogo = findViewById(R.id.ivLogo)
    llImageButtonContainer = findViewById(R.id.llImageContainer)
    setBackgroundOnImage()
  }

  private fun setBackgroundOnImage() {
    val shape = GradientDrawable()
    shape.setColor(TokenRepo.getColorRepo().getBrandColor())
    refresh()
  }

  fun refresh() {
    ivLogo.layoutParams.height = 48.px
    ivLogo.layoutParams.width = 48.px
    ivLogo.isClickable = false
    val imgRes = R.drawable.ic_chat_more_option
    ivLogo.setImageResource(imgRes)
    val shape = GradientDrawable()
    shape.cornerRadius = TokenRepo.getBorderRadiusRepo().getBorderRadius(2).px.toFloat()
    shape.setColor(TokenRepo.getColorRepo().getVideoBackGroundColor())
    ivLogo.setColorFilter(TokenRepo.getColorRepo().getIconColor())
    llImageButtonContainer.background = shape
    gravity = Gravity.CENTER
    ivLogo.scaleType = CENTER
    llImageButtonContainer.gravity = Gravity.CENTER
  }
}

