package dyte.io.uikit.view

import android.content.Context
import android.graphics.Typeface
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import dyte.io.uikit.designtokens.TokenRepo
import dyte.io.uikit.utils.Utils.px

class DyteLabelBackGroundView : androidx.appcompat.widget.AppCompatTextView {
  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  fun init() {
    refresh()
  }

  fun refresh() {

    val shape = GradientDrawable()
    shape.cornerRadius = TokenRepo.getBorderRadiusRepo().getBorderRadius(10).px.toFloat()

    shape.setColor(TokenRepo.getColorRepo().getBrandColor())

    val strokeColor = TokenRepo.getColorRepo().getBrandColor()
    shape.setStroke(
      TokenRepo.getBorderWidthRepo().getBorderWidth(10).px.toFloat().toInt(),
      strokeColor
    )

    background = shape
    setTextColor(TokenRepo.getColorRepo().getIconColor())
    typeface = Typeface.DEFAULT_BOLD
  }
}