package dyte.io.uikit.view

import android.content.Context
import android.util.AttributeSet
import dyte.io.uikit.R
import dyte.io.uikit.wiptoken.DyteUITokens
import io.dyte.core.DyteMobileClient

class DyteMoreToggleButton : DyteControlBarButton {
  private var meeting: DyteMobileClient? = null

  override val defaultIconResId: Int
    get() = R.drawable.ic_more

  override val defaultLabelResId: Int
    get() = R.string.dytemoretogglebutton_label

  constructor(context: Context) : super(context)
  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs)
  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  )

  fun activate(meeting: DyteMobileClient) {
    this.meeting = meeting
  }

  override fun onDetachedFromWindow() {
    meeting = null
    super.onDetachedFromWindow()
  }
}