package dyte.io.uikit.view

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import android.widget.ImageView
import android.widget.LinearLayout
import dyte.io.uikit.DyteUIKitBuilder
import dyte.io.uikit.R
import dyte.io.uikit.atoms.DyteLabelAtom
import dyte.io.uikit.tokens
import dyte.io.uikit.utils.displayDensity
import dyte.io.uikit.wiptoken.BorderRadiusToken.BorderRadiusSize
import io.dyte.core.listeners.DyteParticipantUpdateListener
import io.dyte.core.feat.DyteMeetingParticipant

// TODO : rename to DyteNameTagView ??
class DytePeerNameTag : LinearLayout {
  private lateinit var tvName: DyteLabelAtom
  private lateinit var ivMic: ImageView
  private lateinit var llNameTagView: LinearLayout

  private lateinit var participant: DyteMeetingParticipant

  private val meeting by lazy {
    DyteUIKitBuilder.meeting
  }

  constructor(context: Context) : super(context) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?
  ) : super(context, attrs) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?,
    defStyleAttr: Int
  ) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    inflate(context, R.layout.name_tag_view, this)
    ivMic = findViewById(R.id.ivMic)
    tvName = findViewById(R.id.tvNameTag)
    llNameTagView = findViewById(R.id.llNameTagContainer)
  }


  fun refresh(dyteMeetingParticipant: DyteMeetingParticipant) {
    val shape = GradientDrawable()
    shape.cornerRadius = tokens.borderRadius.getRadius(BorderRadiusSize.TWO, displayDensity)
    shape.setColor(tokens.colors.background.shade1000)
    llNameTagView.background = shape
    participant = dyteMeetingParticipant

    dyteMeetingParticipant.addParticipantUpdateListener(object : DyteParticipantUpdateListener {
      override fun onAudioUpdate(isEnabled: Boolean) {
        super.onAudioUpdate(isEnabled)
        refreshAudioIcon()
      }
    })

    val name = if(meeting.localUser.id == dyteMeetingParticipant.id) {
      dyteMeetingParticipant.name + " (you)"
    } else {
      dyteMeetingParticipant.name
    }
    refreshAudioIcon()

    tvName.text = name
    tvName.maxLines = 1
  }

  private fun refreshAudioIcon() {
    if (participant.audioEnabled) {
      ivMic.setImageResource(R.drawable.ic_mic)
    } else {
      ivMic.setImageResource(R.drawable.ic_mic_off)
    }
  }
}