package dyte.io.uikit.view

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.FrameLayout
import android.widget.LinearLayout
import dyte.io.uikit.R
import dyte.io.uikit.utils.Utils
import dyte.io.uikit.utils.ViewUtils.visible
import io.dyte.core.feat.DyteMeetingParticipant

class DytePeerView : LinearLayout {
  private lateinit var participant: DyteMeetingParticipant

  private lateinit var tvInitials: DyteLabelBackGroundView
  private lateinit var dytePeerNameTag: DytePeerNameTag
  private lateinit var flVideoContainer: FrameLayout

  constructor(context: Context) : super(context) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?
  ) : super(context, attrs) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?,
    defStyleAttr: Int
  ) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    val view = LayoutInflater.from(context).inflate(R.layout.peer_view, this, false)
    addView(view)

    flVideoContainer = findViewById(R.id.flVideoContainer)
    tvInitials = findViewById(R.id.tvInitials)
    dytePeerNameTag = findViewById(R.id.ntNameTag)

    /*videoRenderer.init(
      DyteUIKitBuilder.meeting.localUser.getEglContext() as EglBase.Context,
      object : RendererEvents {
        override fun onFirstFrameRendered() {}

        override fun onFrameResolutionChanged(width: Int, height: Int, rotation: Int) {
          resizeVideoRenderer(width, height)
        }
      }
    )*/
  }

  fun refresh(dyteParticipant: DyteMeetingParticipant) {
    showView()
    this.participant = dyteParticipant
    tag = participant.id

    dytePeerNameTag.refresh(dyteParticipant)

    if (participant.videoEnabled) {
      tvInitials.visibility = View.GONE
    } else {
      tvInitials.visibility = View.VISIBLE
    }

    tvInitials.text = Utils.getInitialsFromName(participant.name)
  }

  private fun showView() {
    tvInitials.visible()
    dytePeerNameTag.visible()
  }

  // private fun resizeVideoRenderer(videoWidth: Int, videoHeight: Int) {
  //   if (videoWidth > 0 && videoHeight > 0) {
  //     post {
  //       doOnLayout { peerView ->
  //         val aspectRatio = videoWidth.toFloat() / videoHeight
  //         val layoutParams = videoRenderer.layoutParams
  //         if (aspectRatio > 1) {
  //           layoutParams.width = peerView.width
  //           layoutParams.height = (peerView.width / aspectRatio).toInt()
  //         } else {
  //           layoutParams.height = peerView.height
  //           layoutParams.width = (peerView.height * aspectRatio).toInt()
  //         }
  //         videoRenderer.layoutParams = layoutParams
  //       }
  //     }
  //   }
  // }
}