package dyte.io.uikit.view

import android.content.Context
import android.os.CountDownTimer
import android.util.AttributeSet
import android.view.View
import android.widget.LinearLayout
import dyte.io.uikit.DyteUIKitBuilder
import dyte.io.uikit.R
import dyte.io.uikit.atoms.DyteLabelAtom
import dyte.io.uikit.utils.Utils

private const val TAG = "DyteEventLogger"

class DyteTimerView : LinearLayout {
  private lateinit var timer: CountDownTimer
  private lateinit var startedAt: String
  private lateinit var tvTimer: DyteLabelAtom

  constructor(context: Context) : super(context) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?
  ) : super(context, attrs) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?,
    defStyleAttr: Int
  ) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    inflate(context, R.layout.timer, this)
    tvTimer = findViewById(R.id.tvTimer)
  }

  fun refresh() {
    startedAt = DyteUIKitBuilder.dyteUIKit.meeting.meta.meetingStartedTimestamp

    timer = object : CountDownTimer(Long.MAX_VALUE, 1000) {
      override fun onTick(p0: Long) {
        val diff = Utils.getDiff(Utils.getUtcTimeNow(), startedAt)
        tvTimer.text = diff
      }

      override fun onFinish() {
      }
    }
    timer.start()

    // tvTimer.refresh()
  }

  override fun onViewRemoved(child: View?) {
    super.onViewRemoved(child)
    timer.cancel()
  }
}