package dyte.io.uikit.view

import android.content.Context
import android.util.AttributeSet
import android.widget.LinearLayout
import android.widget.TextView
import dyte.io.uikit.R
import dyte.io.uikit.atoms.DyteButton
import dyte.io.uikit.tokens
import dyte.io.uikit.wiptoken.DyteUITokens

class FullScreenErrorView: LinearLayout {
  private lateinit var tvMessage: TextView
  private lateinit var btnRetry: DyteButton

  constructor(context: Context) : super(context) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?
  ) : super(context, attrs) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?,
    defStyleAttr: Int
  ) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    inflate(context, R.layout.full_screen_error, this)

    tvMessage = findViewById(R.id.tvErrorMessage)
    btnRetry = findViewById(R.id.btnRetry)
    tvMessage.setTextColor(tokens.colors.status.danger)
    setBackgroundColor(tokens.colors.background.shade1000)
  }

  fun refresh(e:Exception, onRetryClicked: () -> Unit) {
    tvMessage.text = e.localizedMessage
    btnRetry.setOnClickListener {
      onRetryClicked.invoke()
    }
  }
}