package dyte.io.uikit.wiptoken

import android.graphics.Color

open class DyteUITokens(
  open var colors: ColorTokens,
  open var borderWidth: BorderWidthToken = BorderWidthToken.None,
  open var borderRadius: BorderRadiusToken = BorderRadiusToken.Rounded
)

internal object DyteGlobalUITokensFactory {
  fun create(): DyteUITokens {
    val dyteColors = ColorTokens(
      brand = BrandColor(
        shade300 = Color.parseColor("#497CFD"),
        shade400 = Color.parseColor("#356EFD"),
        shade500 = Color.parseColor("#2160FD"),
        shade600 = Color.parseColor("#0D51FD"),
        shade700 = Color.parseColor("#0246FD")
      ),
      background = BackgroundColor(
        shade600 = Color.parseColor("#666666"),
        shade700 = Color.parseColor("#4C4C4C"),
        shade800 = Color.parseColor("#333333"),
        shade900 = Color.parseColor("#1A1A1A"),
        shade1000 = Color.parseColor("#080808")
      ),
      text = TextColor(
        onBrand = TextColor.TextColorOnBrand(
          shade1000 = Color.parseColor("#FF111111"),
          shade900 = Color.parseColor("#E0111111"),
          shade800 = Color.parseColor("#C2111111"),
          shade700 = Color.parseColor("#A3111111"),
          shade600 = Color.parseColor("#85111111"),
        ),
        onBackground = TextColor.TextColorOnBackground(
          shade1000 = Color.parseColor("#FFFFFFFF"),
          shade900 = Color.parseColor("#E0FFFFFF"),
          shade800 = Color.parseColor("#C2FFFFFF"),
          shade700 = Color.parseColor("#A3FFFFFF"),
          shade600 = Color.parseColor("#85FFFFFF"),
        )
      )
    )

    return DyteUITokens(colors = dyteColors, borderRadius = BorderRadiusToken.Rounded)
  }
}