package dyte.io.uikit

import android.app.Activity
import android.content.Intent
import dyte.io.uikit.screens.DyteMeetingActivity
import dyte.io.uikit.wiptoken.DyteGlobalUITokensFactory
import dyte.io.uikit.wiptoken.DyteUITokens
import io.dyte.core.DyteMobileClient
import io.dyte.core.feat.DyteChatMessage
import io.dyte.core.feat.DytePollMessage
import io.dyte.core.listeners.DyteChatEventsListener
import io.dyte.core.listeners.DytePollEventsListener
import io.dyte.core.models.DyteMeetingInfo
import io.dyte.core.models.DyteMeetingInfoV2

data class DyteUIKit(
  val activity: Activity,
  val meetingInfo: DyteMeetingInfo?,
  val meetingInfoV2: DyteMeetingInfoV2?,
  val meeting: DyteMobileClient,
  val tokens: DyteUITokens = DyteGlobalUITokensFactory.create()
) {
  internal var isNewChatAvailable: Boolean = false
  internal var isNewPollAvailable: Boolean = false

  private val chatEventsListener = object : DyteChatEventsListener {
    override fun onChatUpdates(messages: List<DyteChatMessage>) {
      super.onChatUpdates(messages)
      isNewChatAvailable = true
    }
  }

  private val pollEventsListener = object : DytePollEventsListener {
    override fun onNewPoll(poll: DytePollMessage) {
      super.onNewPoll(poll)
      isNewPollAvailable = true
    }
  }

  fun loadUi() {
    meeting.addChatEventsListener(chatEventsListener)
    meeting.addPollEventsListener(pollEventsListener)
    activity.startActivity(Intent(activity, DyteMeetingActivity::class.java))
  }

  internal fun onChatScreenOpened() {
    isNewChatAvailable = false
  }

  internal fun onPollScreenOpened() {
    isNewPollAvailable = false
  }
}