package dyte.io.uikit

import android.annotation.SuppressLint
import android.app.Activity
import dyte.io.uikit.wiptoken.DyteGlobalUITokensFactory
import dyte.io.uikit.wiptoken.DyteUITokens
import io.dyte.core.DyteAndroidClientBuilder
import io.dyte.core.models.DyteMeetingInfo
import io.dyte.core.models.DyteMeetingInfoV2
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers

internal var tokens: DyteUITokens = DyteUIKitBuilder.dyteUIKit.tokens

object DyteUIKitBuilder {
  @SuppressLint("StaticFieldLeak")
  internal lateinit var dyteUIKit: DyteUIKit

  val meeting by lazy {
    dyteUIKit.meeting
  }

  fun build(config: DyteUIKitConfig): DyteUIKit {
    val meeting = DyteAndroidClientBuilder.build(config.activity)
    dyteUIKit = DyteUIKit(
      config.activity,
      config.dyteMeetingInfo,
      null,
      meeting,
      config.designTokens
    )
    tokens = config.designTokens
    return dyteUIKit
  }

  fun build(config: DyteUIKitConfigV2): DyteUIKit {
    val meeting = DyteAndroidClientBuilder.build(config.activity)
    dyteUIKit = DyteUIKit(
      config.activity,
      null,
      config.dyteMeetingInfo,
      meeting,
      config.designTokens
    )
    tokens = config.designTokens
    return dyteUIKit
  }
}

data class DyteUIKitConfig(
  val activity: Activity,
  val dyteMeetingInfo: DyteMeetingInfo,
  val designTokens: DyteUITokens = DyteGlobalUITokensFactory.create()
)

data class DyteUIKitConfigV2(
  val activity: Activity,
  val dyteMeetingInfo: DyteMeetingInfoV2,
  val designTokens: DyteUITokens = DyteGlobalUITokensFactory.create()
)