package dyte.io.uikit.atoms

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import dyte.io.uikit.designtokens.TokenRepo
import dyte.io.uikit.tokens
import dyte.io.uikit.utils.displayDensity
import dyte.io.uikit.wiptoken.BorderRadiusToken.BorderRadiusSize
import dyte.io.uikit.wiptoken.DyteUITokens

class DyteButton : androidx.appcompat.widget.AppCompatButton {
  constructor(context: Context) : super(context) {
    init()
  }

  /*constructor(context: Context, uiTokens: DyteUITokens = token) : super(context) {
    init(uiTokens)
  }*/

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  fun init() {
    refresh(tokens)
  }

  fun refresh(uiTokens: DyteUITokens) {
    val shape = GradientDrawable()
    // Set color
    shape.setColor(uiTokens.colors.brand.shade500)
    // Set corner radius
    shape.cornerRadius = uiTokens.borderRadius.getRadius(BorderRadiusSize.ONE, displayDensity)

    background = shape

    // Set text color
    setTextColor(uiTokens.colors.text.onBackground.shade1000)

    // Set font size
    val fontSize = TokenRepo.getFontSizeRepo().getFontSize()
    textSize = fontSize
    transformationMethod = null
  }
}