package dyte.io.uikit.atoms

import android.content.Context
import android.util.AttributeSet
import com.google.android.material.textfield.TextInputEditText
import dyte.io.uikit.tokens
import dyte.io.uikit.utils.Utils.px
import dyte.io.uikit.utils.ViewUtils.setBackground
import dyte.io.uikit.wiptoken.DyteUITokens

class DyteInputFieldAtom : TextInputEditText {
  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    refresh(tokens)
  }

  fun refresh(uiTokens: DyteUITokens) {
    setBackground(uiTokens.borderRadius, uiTokens.colors.background.shade1000)
    setTextColor(uiTokens.colors.text.onBackground.shade1000)
    setHintTextColor(uiTokens.colors.text.onBackground.shade900)
    setPadding(16.px, 8.px, 16.px, 8.px)
  }
}