package dyte.io.uikit.atoms

import android.content.Context
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatImageView
import dyte.io.uikit.R
import dyte.io.uikit.wiptoken.DyteUITokens
import io.dyte.core.feat.DyteMeetingParticipant
import io.dyte.core.listeners.DyteParticipantUpdateListener

class DyteParticipantAudioIndicator: AppCompatImageView {
  private lateinit var participant: DyteMeetingParticipant

  private val participantUpdateListener = object : DyteParticipantUpdateListener {
    override fun onAudioUpdate(isEnabled: Boolean) {
      super.onAudioUpdate(isEnabled)
      _refresh()
    }
  }

  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    setImageResource(R.drawable.ic_mic_off)
  }

  fun refresh(uiTokens: DyteUITokens) {

  }

  private fun _refresh() {
    if(participant.audioEnabled) {
      setImageResource(R.drawable.ic_mic)
    } else {
      setImageResource(R.drawable.ic_mic_off)
    }
  }

  fun activate(participant: DyteMeetingParticipant) {
    this.participant = participant
    participant.removeParticipantUpdateListener(participantUpdateListener)
    participant.addParticipantUpdateListener(participantUpdateListener)
    _refresh()
  }

  fun deactivate() {
    participant.removeParticipantUpdateListener(participantUpdateListener)
  }
}