package dyte.io.uikit.atoms

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import android.view.View
import dyte.io.uikit.tokens
import dyte.io.uikit.wiptoken.DyteUITokens

class DyteSeparatorView : View {
  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init(uiTokens: DyteUITokens = tokens) {
    val shape = GradientDrawable()
    shape.setColor(uiTokens.colors.background.shade700)
    background = shape
  }
}