package dyte.io.uikit.designtokens

enum class BorderWidthType {
  NONE,
  THIN,
  FAT;
}

class BorderWidthRepo(private val designToken: DyteDesignToken) : BorderWidthRepoType {
  override fun getBorderWidth(barSize: Int): Int {
    return when (designToken.borderWidthType) {
      BorderWidthType.NONE -> barSize * 0
      BorderWidthType.THIN -> barSize * 1
      BorderWidthType.FAT -> barSize * 2
    }
  }
}

interface BorderWidthRepoType {
  fun getBorderWidth(barSize: Int): Int
}