package dyte.io.uikit.designtokens

import android.util.Log

class FontSizeRepo(private val dyteDesignToken: DyteDesignToken) : FontSizeRepoType {
  private val baseFontSize = 16

  private val fontSizeToMultiplierMap = hashMapOf(
    "font-size-250" to 2.5F,
    "font-size-200" to 2F,
    "font-size-150" to 1.5F,
    "font-size-100" to 1F,
    "font-size-88" to 0.875F,
    "font-size-75" to 0.75F
  )

  override fun getFontSize(): Float {
    val multiplier = fontSizeToMultiplierMap[dyteDesignToken.fontSize] ?: 1F
    return baseFontSize * multiplier
  }
}

interface FontSizeRepoType {
  fun getFontSize(): Float
}