package dyte.io.uikit.designtokens

import android.graphics.Typeface
import dyte.io.uikit.designtokens.FontStyleToken.BOLD
import dyte.io.uikit.designtokens.FontStyleToken.MEDIUM
import dyte.io.uikit.designtokens.FontStyleToken.THIN

enum class FontStyleToken {
  BOLD,
  MEDIUM,
  THIN;
}

class FontStyleRepo(private val dyteDesignToken: DyteDesignToken) : FontStyleRepoType {
  private val fontStyleToTokenName = hashMapOf(
    "font-style-regular" to BOLD,
    "font-style-italic" to MEDIUM,
    "font-style-underline" to THIN,
  )

  override fun getFontStyle(): Int {
    return when (fontStyleToTokenName[dyteDesignToken.fontStyle] ?: BOLD) {
      BOLD -> Typeface.BOLD
      MEDIUM -> Typeface.NORMAL
      THIN -> Typeface.ITALIC
    }
  }
}

interface FontStyleRepoType {
  fun getFontStyle(): Int
}