package dyte.io.uikit.molecules.dytegrid

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.RelativeLayout
import androidx.core.view.children
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.GridLayoutManager.SpanSizeLookup
import androidx.recyclerview.widget.ListAdapter
import androidx.recyclerview.widget.RecyclerView
import dyte.io.uikit.DyteUIKitBuilder
import dyte.io.uikit.R
import dyte.io.uikit.atoms.DytePluginTagTextView
import dyte.io.uikit.atoms.DyteScreenShareTagTextView
import dyte.io.uikit.atoms.DyteTagTextView
import dyte.io.uikit.molecules.DyteVideoPeer
import dyte.io.uikit.molecules.dytegrid.GridPage.GridAutoPage
import dyte.io.uikit.molecules.dytegrid.GridPage.GridPeersPage
import dyte.io.uikit.molecules.dytegrid.GridPagesAdapter.GridPageHolder
import dyte.io.uikit.utils.ViewUtils.gone
import dyte.io.uikit.utils.ViewUtils.visible
import io.dyte.core.feat.DyteMeetingParticipant
import io.dyte.core.feat.DytePlugin

class GridPagesAdapter : ListAdapter<GridPage, GridPageHolder>(GridPageDiffUtil()) {
  override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): GridPageHolder {
    return when (viewType) {
      0 -> {
        ActivePageViewHolder(LayoutInflater.from(parent.context)
          .inflate(R.layout.grid_active_page, parent, false))
      }

      1 -> {
        PageViewHolder(LayoutInflater.from(parent.context)
          .inflate(R.layout.grid_peers_page, parent, false))
      }

      else -> {
        throw IllegalArgumentException("un-supported view type $viewType")
      }
    }
  }

  override fun onBindViewHolder(holder: GridPageHolder, position: Int) {
    holder.bindData()
  }

  override fun getItemViewType(position: Int): Int {
    return when (getItem(position)) {
      GridAutoPage -> 0
      GridPeersPage -> 1
    }
  }

  class PageViewHolder(view: View): GridPageHolder(view) {
    private val meeting by lazy {
      DyteUIKitBuilder.meeting
    }

    private lateinit var adapter: PeersPageAdapter
    private val peerHelper = PeerHelper()

    private var rvPeers: RecyclerView

    init {
      rvPeers = view.findViewById(R.id.rvPeers)
    }

    override fun bindData() {
      println("DyteMobileClient | PageViewHolder refreshGrid ")
      val participants = meeting.participants.active

      println("DyteMobileClient | PageViewHolder refreshGrid ${participants.map { it.name }}")

      val childs = peerHelper.getChilds(participants)
      println("DyteMobileClient | PageViewHolder refreshGrid ${childs.size}")
      val gridLayoutManager = GridLayoutManager(rvPeers.context, 2)
      gridLayoutManager.spanSizeLookup = object : SpanSizeLookup() {
        override fun getSpanSize(position: Int): Int {
          if (position >= childs.size) {
            return 2
          }
          return childs[position].span
        }
      }
      rvPeers.layoutManager = gridLayoutManager
      if (rvPeers.adapter == null) {
        adapter = PeersPageAdapter()
        rvPeers.adapter = adapter
      }
      adapter.submitList(childs)
    }
  }

  class ActivePageViewHolder(view: View): GridPageHolder(view) {
    private var llScreenShareContainer: View
    private var llScreenShareTags: LinearLayout
    private var clSS: RelativeLayout
    private var dpvFloating: DyteVideoPeer

    private val pluginWebViews = hashMapOf<String, android.webkit.WebView>()

    private val meeting by lazy {
      DyteUIKitBuilder.meeting
    }

    init {
      llScreenShareContainer = view.findViewById(R.id.llScreenshareContainer)
      llScreenShareTags = view.findViewById(R.id.llScreenShareTags)
      clSS = view.findViewById(R.id.clScreenshare)
      dpvFloating = view.findViewById(R.id.dvpFloating)
    }

    override fun bindData() {
      println("DyteMobileClient | GridActivePageFragment refreshScreenShareAndActivePlugins ")

      val screenSharePeers = meeting.participants.screenshares
      val plugins = meeting.plugins.active

      val pinnedParticipant = meeting.participants.pinned
      pinnedParticipant?.let {
        println("DyteMobileClient | ActivePageViewHolder bindData we've pinned")
        dpvFloating.visible()
        dpvFloating.refresh(pinnedParticipant)
      } ?: kotlin.run {
        dpvFloating.gone()
      }

      if (pinnedParticipant == null) {
        val activeSpeaker = meeting.participants.activeSpeaker
        activeSpeaker?.let {
          println("DyteMobileClient | ActivePageViewHolder bindData we've active")
          dpvFloating.visible()
          dpvFloating.refresh(activeSpeaker)
        } ?: kotlin.run {
          dpvFloating.gone()
        }
      }

      if (screenSharePeers.isNotEmpty() && plugins.isEmpty()) {
        if (screenSharePeers.size == 1) {
          llScreenShareTags.gone()
        } else {
          llScreenShareTags.removeAllViews()
          screenSharePeers.forEach { participant ->
            addScreenShareTagView(participant)
          }
          llScreenShareTags.visible()
          llScreenShareTags.children.first().performClick()
        }
        addScreenSharePeer(screenSharePeers.first())
        llScreenShareContainer.visible()
      }

      if (screenSharePeers.isEmpty() && plugins.isNotEmpty()) {
        if (plugins.size == 1) {
          llScreenShareTags.gone()
        } else {
          llScreenShareTags.removeAllViews()
          plugins.forEach { plugin ->
            addPluginTagView(plugin)
          }
          llScreenShareTags.visible()
          llScreenShareTags.children.first().performClick()
        }
        addPluginView(plugins.first())
        llScreenShareContainer.visible()
      }

      if (screenSharePeers.isNotEmpty() && plugins.isNotEmpty()) {
        llScreenShareTags.removeAllViews()
        plugins.forEach { plugin ->
          addPluginTagView(plugin)
        }
        screenSharePeers.forEach { participant ->
          addScreenShareTagView(participant)
        }
        llScreenShareTags.visible()
        llScreenShareTags.children.first().performClick()
        llScreenShareContainer.visible()
      }
    }

    private fun addScreenShareTagView(participant: DyteMeetingParticipant) {
      println("DyteMobileClient | GridActivePageFragment addScreenShareTagView ")
      val tagView = DyteScreenShareTagTextView(itemView.context)
      tagView.text = participant.name
      tagView.setOnClickListener {
        addScreenSharePeer(participant)
        llScreenShareTags.children.forEach {
          (it as DyteTagTextView).setUnSelected()
        }
        tagView.setSelected()
      }
      llScreenShareTags.addView(tagView)
      val params = tagView.layoutParams as LinearLayout.LayoutParams
      params.setMargins(8, 2,8,2)
      tagView.layoutParams = params
    }

    private fun addScreenSharePeer(screenShareParticipant: DyteMeetingParticipant) {
      println("DyteMobileClient | GridActivePageFragment addScreenSharePeer ")
      val screenShareView = screenShareParticipant.getScreenShareVideoView()
      (screenShareView.parent as? ViewGroup)?.removeView(screenShareView)
      clSS.removeAllViews()
      clSS.addView(screenShareView)
      screenShareView.renderScreenShare()
    }

    private fun addPluginTagView(plugin: DytePlugin) {
      val tagView = DytePluginTagTextView(itemView.context)
      tagView.text = plugin.name
      tagView.setOnClickListener {
        addPluginView(plugin)
        llScreenShareTags.children.forEach {
          (it as DyteTagTextView).setUnSelected()
        }
        tagView.setSelected()
      }
      llScreenShareTags.addView(tagView)
      val params = tagView.layoutParams as LinearLayout.LayoutParams
      params.setMargins(8, 2,8,2)
    }

    private fun addPluginView(dytePlugin: DytePlugin) {
      var pluginView = pluginWebViews[dytePlugin.id]
      if (pluginView == null) {
        pluginView = dytePlugin.getPluginView()
        pluginWebViews[dytePlugin.id] = pluginView
      }
      clSS.removeAllViews()
      (pluginView.parent as? ViewGroup)?.removeView(pluginView)
      clSS.addView(pluginView)
      pluginView.layoutParams = RelativeLayout.LayoutParams(
        RelativeLayout.LayoutParams.MATCH_PARENT,
        RelativeLayout.LayoutParams.MATCH_PARENT
      )
    }
  }

  abstract class GridPageHolder(view: View): RecyclerView.ViewHolder(view) {
    abstract fun bindData()
  }
}
