package dyte.io.uikit.molecules.dytegrid

import androidx.recyclerview.widget.DiffUtil
import dyte.io.uikit.molecules.dytegrid.GridPage.GridAutoPage
import dyte.io.uikit.molecules.dytegrid.GridPage.GridPeersPage

class PeerAdapterDiffUtil : DiffUtil.ItemCallback<GridChildData>() {
  override fun areItemsTheSame(oldItem: GridChildData, newItem: GridChildData): Boolean {
    return oldItem.participant.id == newItem.participant.id && oldItem.type.ordinal == newItem.type.ordinal
  }

  override fun areContentsTheSame(oldItem: GridChildData, newItem: GridChildData): Boolean {
    return (oldItem.participant.id == newItem.participant.id
      && oldItem.participant.videoEnabled == newItem.participant.videoEnabled
      && oldItem.participant.audioEnabled == newItem.participant.audioEnabled)
  }
}

class GridPageDiffUtil : DiffUtil.ItemCallback<GridPage>() {
  override fun areItemsTheSame(oldItem: GridPage, newItem: GridPage): Boolean {
    return if (oldItem is GridAutoPage && newItem is GridAutoPage) {
      true
    } else oldItem is GridPeersPage && newItem is GridPeersPage
  }

  override fun areContentsTheSame(oldItem: GridPage, newItem: GridPage): Boolean {
    // TODO : this causes ui to jump on grid, fix this
    return false
  }
}