package dyte.io.uikit.molecules.dytegrid

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.RelativeLayout
import androidx.cardview.widget.CardView
import androidx.recyclerview.widget.GridLayoutManager.LayoutParams
import androidx.recyclerview.widget.ListAdapter
import androidx.recyclerview.widget.RecyclerView
import coil.load
import coil.transform.CircleCropTransformation
import dyte.io.uikit.R
import dyte.io.uikit.atoms.DytePeerInitialsTextView
import dyte.io.uikit.molecules.dytegrid.PeersPageAdapter.PeerViewHolder
import dyte.io.uikit.molecules.dytegrid.GridViewType.FullWidthFullHeight
import dyte.io.uikit.molecules.dytegrid.GridViewType.FullWidthHalfHeight
import dyte.io.uikit.molecules.dytegrid.GridViewType.FullWidthThirdHeight
import dyte.io.uikit.molecules.dytegrid.GridViewType.HalfWidthFullHeight
import dyte.io.uikit.molecules.dytegrid.GridViewType.HalfWidthHalfHeight
import dyte.io.uikit.molecules.dytegrid.GridViewType.HalfWidthThirdHeight
import dyte.io.uikit.tokens
import dyte.io.uikit.utils.Utils
import dyte.io.uikit.utils.ViewUtils.gone
import dyte.io.uikit.utils.ViewUtils.visible
import dyte.io.uikit.utils.displayDensity
import dyte.io.uikit.view.DytePeerNameTag
import dyte.io.uikit.wiptoken.BorderRadiusToken.BorderRadiusSize
import io.dyte.core.listeners.DyteParticipantUpdateListener
import io.dyte.core.feat.DyteMeetingParticipant

class PeersPageAdapter internal constructor() :
  ListAdapter<GridChildData, PeerViewHolder>(PeerAdapterDiffUtil()) {
  override fun onCreateViewHolder(
    parent: ViewGroup,
    viewType: Int
  ): PeerViewHolder {
    val view = LayoutInflater.from(parent.context)
      .inflate(R.layout.view_video_peer, parent, false)

    when (GridViewType.values()[viewType]) {
      FullWidthFullHeight -> {
        view.layoutParams = LayoutParams(parent.width, parent.height)
      }
      FullWidthHalfHeight -> {
        view.layoutParams = LayoutParams(parent.width, parent.height / 2)
      }
      HalfWidthFullHeight -> {
        view.layoutParams = LayoutParams(parent.width / 2, parent.height)
      }
      HalfWidthHalfHeight -> {
        view.layoutParams =
          LayoutParams(parent.width / 2, parent.height / 2)
      }
      HalfWidthThirdHeight -> {
        view.layoutParams =
          LayoutParams(parent.width / 2, parent.height / 3)
      }
      FullWidthThirdHeight -> {
        view.layoutParams = LayoutParams(parent.width, parent.height / 3)
      }
    }
    return PeerViewHolder(view)
  }

  override fun getItemViewType(position: Int): Int {
    return getItem(position).type.ordinal
  }

  override fun onBindViewHolder(
    holder: PeerViewHolder,
    position: Int
  ) {
    println("DyteMobileClient | GridRecyclerAdapter onBindViewHolder ")
    holder.bind(getItem(position).participant)
  }

  inner class PeerViewHolder internal constructor(itemView: View) :
    RecyclerView.ViewHolder(itemView) {
    private var tvInitials: DytePeerInitialsTextView
    private var tvName: DytePeerNameTag
    private var ivImage: ImageView
    private var cvVideoContainer: CardView
    private var flVideoContainer: RelativeLayout

    private lateinit var participantUpdateListener: DyteParticipantUpdateListener
    private lateinit var participant: DyteMeetingParticipant

    init {
      flVideoContainer = itemView.findViewById(R.id.selfVideoRenderer)
      tvInitials = itemView.findViewById(R.id.tvSelfInitials)
      tvName = itemView.findViewById(R.id.tvName)
      ivImage = itemView.findViewById(R.id.ivPeerImageView)
      cvVideoContainer = itemView.findViewById(R.id.cvVideoContainer)

      cvVideoContainer.radius =
        tokens.borderRadius.getRadius(BorderRadiusSize.TWO, itemView.displayDensity)
      cvVideoContainer.setCardBackgroundColor(tokens.colors.videoBackground)
    }

    fun bind(dyteParticipant: DyteMeetingParticipant) {
      println("DyteMobileClient | ViewHolder bind ${dyteParticipant.name}")
      refresh(dyteParticipant)
    }

    fun refresh(participant: DyteMeetingParticipant) {
      this.participant = participant
      tvName.refresh(participant)

      participant.removeParticipantUpdateListeners()

      refreshName()
      render(participant)
      participantUpdateListener = object : DyteParticipantUpdateListener {
        override fun onVideoUpdate(isEnabled: Boolean) {
          super.onVideoUpdate(isEnabled)
          render(participant)
        }
      }

      val nameInitials = Utils.getInitialsFromName(participant.name)
      tvInitials.visibility = View.VISIBLE
      tvInitials.text = nameInitials
      participant.addParticipantUpdateListener(participantUpdateListener)
    }

    private fun refreshName() {
      if (participant.name.isNotEmpty()) {
        refreshPlaceholder()
      } else {
        tvInitials.visibility = View.GONE
      }
      tvName.refresh(participant)
    }

    private fun refreshPlaceholder() {
      println("DyteMobileClient | DyteVideoPeer refreshPlaceholder ")
      if (participant.videoEnabled) {
        println("DyteMobileClient | DyteVideoPeer refreshPlaceholder video is enabled")
        return
      }
      if (participant.picture?.isNotEmpty() == true) {
        println("DyteMobileClient | DyteVideoPeer refreshPlaceholder we've image")
        ivImage.visible()
        ivImage.load(participant.picture) {
          transformations(CircleCropTransformation())
        }
        tvInitials.gone()
      } else {
        println("DyteMobileClient | DyteVideoPeer refreshPlaceholder no image")
        val nameInitials = Utils.getInitialsFromName(participant.name)
        tvInitials.visible()
        tvInitials.text = nameInitials
      }
    }

    private fun render(participant: DyteMeetingParticipant) {
      println("DyteMobileClient | PeerViewHolder render ${participant.name} ${participant.videoEnabled} ${participant.audioEnabled}")
      val videoView = participant.getVideoView()
      if (participant.videoEnabled && participant.videoTrack != null) {
        flVideoContainer.removeAllViews()
        (videoView?.parent as? ViewGroup)?.removeView(videoView)
        flVideoContainer.addView(videoView)
        videoView?.renderVideo()
        flVideoContainer.visible()
      } else {
        flVideoContainer.gone()
      }
      refreshPlaceholder()
    }
  }

  override fun onViewRecycled(holder: PeerViewHolder) {
    super.onViewRecycled(holder)
    println("DyteMobileClient | GridRecyclerAdapter onViewRecycled ")
    // holder.recycle()
  }
}