package dyte.io.uikit.screens.chat

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.ListAdapter
import dyte.io.uikit.R
import io.dyte.core.feat.DyteChatMessage
import io.dyte.core.feat.DyteFileMessage
import io.dyte.core.feat.DyteImageMessage
import io.dyte.core.feat.DyteTextMessage

class ChatMessageListAdapter(
  private val onImageClick: (String) -> Unit,
  private val onDownloadFileClick: (fileName: String, link: String) -> Unit
) : ListAdapter<DyteChatMessage, BaseMessageViewHolder<out DyteChatMessage>>(
  ChatMessageDiffCallback()
) {

  override fun onCreateViewHolder(
    parent: ViewGroup,
    viewType: Int
  ): BaseMessageViewHolder<out DyteChatMessage> {
    val layoutInflater = LayoutInflater.from(parent.context)
    return when (viewType) {
      VIEW_TYPE_IMAGE -> {
        ImageMessageViewHolder(
          layoutInflater.inflate(
            R.layout.list_item_chat_image_message,
            parent,
            false
          ),
          onImageClick
        )
      }
      VIEW_TYPE_FILE -> {
        FileMessageViewHolder(
          layoutInflater.inflate(
            R.layout.list_item_chat_file_message,
            parent,
            false
          ),
          onDownloadFileClick
        )
      }
      else -> {
        TextMessageViewHolder(
          layoutInflater.inflate(
            R.layout.list_item_chat_text_message,
            parent,
            false
          )
        )
      }
    }
  }

  override fun onBindViewHolder(holder: BaseMessageViewHolder<out DyteChatMessage>, position: Int) {
    holder.bindChatMessage(getItem(position))
  }

  override fun getItemViewType(position: Int): Int {
    return when (getItem(position)) {
      is DyteImageMessage -> VIEW_TYPE_IMAGE
      is DyteFileMessage -> VIEW_TYPE_FILE
      else -> {
        VIEW_TYPE_TEXT
      }
    }
  }

  companion object {
    private const val VIEW_TYPE_TEXT = 1
    private const val VIEW_TYPE_IMAGE = 2
    private const val VIEW_TYPE_FILE = 3
  }
}

private class ChatMessageDiffCallback<T : DyteChatMessage> : DiffUtil.ItemCallback<T>() {
  override fun areItemsTheSame(oldItem: T, newItem: T): Boolean {
    if (oldItem is DyteTextMessage && newItem is DyteTextMessage) {
      return true
    }
    if (oldItem is DyteImageMessage && newItem is DyteImageMessage) {
      return true
    }
    if (oldItem is DyteFileMessage && newItem is DyteFileMessage) {
      return true
    }
    return false
  }

  // TODO: Either implement equals() or compare the necessary contents manually
  override fun areContentsTheSame(oldItem: T, newItem: T): Boolean {
    if (oldItem is DyteTextMessage && newItem is DyteTextMessage) {
      return oldItem.message == newItem.message
    }
    if (oldItem is DyteImageMessage && newItem is DyteImageMessage) {
      return oldItem.link == newItem.link
    }
    if (oldItem is DyteFileMessage && newItem is DyteFileMessage) {
      return oldItem.link == newItem.link
    }
    return false
  }
}