package dyte.io.uikit.screens.livestream

import android.graphics.drawable.GradientDrawable
import android.net.Uri
import android.os.Bundle
import android.view.LayoutInflater
import android.view.SurfaceHolder
import android.view.SurfaceView
import android.view.View
import android.view.ViewGroup
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import com.amazonaws.ivs.player.Player
import com.amazonaws.ivs.player.PlayerView
import com.amazonaws.ivs.player.ResizeMode.ZOOM
import dyte.io.uikit.DyteUIKitBuilder
import dyte.io.uikit.R
import dyte.io.uikit.atoms.DyteButton
import dyte.io.uikit.atoms.DyteCameraToggleButton
import dyte.io.uikit.atoms.DyteImageButton
import dyte.io.uikit.atoms.DyteLabelAtom
import dyte.io.uikit.screens.livestream.DyteLiveStreamViewModel.LiveStreamActionsState
import dyte.io.uikit.screens.livestream.DyteLiveStreamViewModel.LiveStreamActionsState.Blocked
import dyte.io.uikit.screens.livestream.DyteLiveStreamViewModel.LiveStreamActionsState.Starting
import dyte.io.uikit.screens.livestream.DyteLiveStreamViewModel.LiveStreamControlBarState.CanDoControls
import dyte.io.uikit.screens.livestream.DyteLiveStreamViewModel.LiveStreamControlBarState.CantDoControls
import dyte.io.uikit.screens.livestream.DyteLiveStreamViewModel.LiveStreamState.Ended
import dyte.io.uikit.screens.livestream.DyteLiveStreamViewModel.LiveStreamState.Errored
import dyte.io.uikit.screens.livestream.DyteLiveStreamViewModel.LiveStreamState.Idle
import dyte.io.uikit.screens.livestream.DyteLiveStreamViewModel.LiveStreamState.Started
import dyte.io.uikit.tokens
import dyte.io.uikit.utils.ViewUtils.gone
import dyte.io.uikit.utils.ViewUtils.visible
import dyte.io.uikit.view.DyteLeaveButton
import dyte.io.uikit.view.DyteLiveStreamToggleButton
import dyte.io.uikit.view.DyteMicToggleButton
import dyte.io.uikit.view.DyteMoreToggleButton
import dyte.io.uikit.view.FullScreenLoaderView
import dyte.io.uikit.wiptoken.BorderRadiusToken.BorderRadiusSize

class DyteLiveStreamFragment : Fragment() {
  private lateinit var dibClose: DyteImageButton
  private lateinit var dfslLoader: FullScreenLoaderView

  private lateinit var clStateContainer: ConstraintLayout
  private lateinit var dabLeave: DyteButton
  private lateinit var dlaMessage: DyteLabelAtom

  private lateinit var playerView: PlayerView
  private lateinit var player: Player

  private lateinit var parentContainer: View
  private lateinit var liveStreamContainer: ConstraintLayout

  private lateinit var livestreamToggleButton: DyteLiveStreamToggleButton
  private lateinit var micToggle: DyteMicToggleButton
  private lateinit var cameraToggle: DyteCameraToggleButton
  private lateinit var endCall: DyteLeaveButton
  private lateinit var moreOptions: DyteMoreToggleButton

  private lateinit var viewModel: DyteLiveStreamViewModel

  private val surfaceCallback = object : SurfaceHolder.Callback {
    override fun surfaceCreated(p0: SurfaceHolder) {
      println("DyteMobileClient | DyteLiveStreamFragment surfaceCreated ")
      player.setSurface(p0.surface)
      /*val url = viewModel.getLiveStreamUrl()
      url?.let {
        dfslLoader.gone()
        liveStreamContainer.visible()
        clStateContainer.gone()
        player.load(Uri.parse(url))
        player.play()
      }*/
    }

    override fun surfaceChanged(p0: SurfaceHolder, p1: Int, p2: Int, p3: Int) {
      println("DyteMobileClient | DyteLiveStreamFragment surfaceChanged ")
      player.setSurface(p0.surface)
      // player.play()
    }

    override fun surfaceDestroyed(p0: SurfaceHolder) {
      println("DyteMobileClient | DyteLiveStreamFragment surfaceDestroyed ")
      player.setSurface(null)
    }
  }


  override fun onCreateView(
    inflater: LayoutInflater, container: ViewGroup?,
    savedInstanceState: Bundle?
  ): View? {
    return inflater.inflate(R.layout.fragment_dyte_livestream, container, false)
  }

  override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
    super.onViewCreated(view, savedInstanceState)

    dibClose = view.findViewById(R.id.dibClose)

    clStateContainer = view.findViewById(R.id.clStateContainer)
    dabLeave = view.findViewById(R.id.dabLeave)
    dlaMessage = view.findViewById(R.id.dlaMessage)

    dfslLoader = view.findViewById(R.id.fslvLoader)

    parentContainer = view.findViewById(R.id.main_view)
    liveStreamContainer = view.findViewById(R.id.clSurfaceContainer)

    livestreamToggleButton = view.findViewById(R.id.dytelivestreamtoggle_meeting_screen)
    micToggle = view.findViewById(R.id.dytemictoggle_meeting_screen)
    cameraToggle = view.findViewById(R.id.dytecameratoggle_meeting_screen)
    endCall = view.findViewById(R.id.dyteleavebutton_meeting_screen)
    moreOptions = view.findViewById(R.id.dytemoretoggle_meeting_screen)

    livestreamToggleButton.activate(DyteUIKitBuilder.meeting)
    micToggle.activate(DyteUIKitBuilder.meeting)
    cameraToggle.activate(DyteUIKitBuilder.meeting)
    endCall.activate(DyteUIKitBuilder.meeting)
    moreOptions.activate(DyteUIKitBuilder.meeting)

    val shape = GradientDrawable()
    shape.setColor(tokens.colors.background.shade900)
    val radius = tokens.borderRadius.getRadius(BorderRadiusSize.TWO, requireContext().resources.displayMetrics.density)
    shape.cornerRadii = floatArrayOf(radius, radius, radius, radius, 0f, 0f, 0f, 0f)
    parentContainer.background = shape

    // playerView = PlayerView(requireContext())
    // player = playerView.player

    dabLeave.setOnClickListener {
      requireActivity().finish()
    }

    dibClose.setOnClickListener {
      requireActivity().finish()
    }

    viewModel = ViewModelProvider(this)[DyteLiveStreamViewModel::class.java]
    viewModel.liveStreamStateLiveData.observe(viewLifecycleOwner) { liveStreamState ->
      println("DyteMobileClient | DyteLiveStreamFragment onViewCreated update state ${liveStreamState.javaClass.simpleName}")
      when(liveStreamState) {
        Idle -> {
          liveStreamNotStarted()
        }
        is Started -> {
          liveStreamStarted()
        }
        Ended -> {
          liveStreamEnded()
        }
        Errored -> {
          liveStreamErrored()
        }
      }
    }
    viewModel.liveStreamActionStateLiveData.observe(viewLifecycleOwner) { liveStreamActionState ->
      when (liveStreamActionState) {
        Blocked -> {

        }
        LiveStreamActionsState.Idle -> {

        }
        Starting -> {

        }
      }
    }
    viewModel.liveStreamControlBarStateLiveData.observe(viewLifecycleOwner) {liveStreamControlBarState ->
      when (liveStreamControlBarState) {
        CanDoControls -> {
          showControls()
        }
        CantDoControls -> {
          hideControls()
        }
      }
    }

    // viewModel.start()
    /*player.addListener(object : Player.Listener() {
      override fun onCue(p0: Cue) {

      }

      override fun onDurationChanged(p0: Long) {

      }

      override fun onStateChanged(p0: State) {
        println("DyteMobileClient | DyteLiveStreamFragment onStateChanged $p0")
      }

      override fun onError(p0: PlayerException) {
        println("DyteMobileClient | DyteLiveStreamFragment onError ${p0.errorMessage}")
      }

      override fun onRebuffering() {

      }

      override fun onSeekCompleted(p0: Long) {

      }

      override fun onVideoSizeChanged(p0: Int, p1: Int) {

      }

      override fun onQualityChanged(p0: Quality) {

      }
    })*/
  }

  private fun showControls() {
    livestreamToggleButton.visible()
    cameraToggle.visible()
    micToggle.visible()
    endCall.visible()
    moreOptions.visible()
  }

  private fun hideControls() {
    cameraToggle.gone()
    micToggle.gone()
    endCall.visible()
    moreOptions.visible()
    livestreamToggleButton.gone()
  }

  private fun liveStreamEnded() {
    liveStreamContainer.gone()
    dfslLoader.gone()
    clStateContainer.visible()
    dlaMessage.text = "Live stream has ended."
  }

  private fun liveStreamStarted() {
    dfslLoader.gone()
    clStateContainer.gone()
    addSurface()
    liveStreamContainer.visible()
  }

  private fun liveStreamErrored() {
    liveStreamContainer.gone()
    dfslLoader.gone()
    clStateContainer.visible()
    dlaMessage.text = "Something went wrong"
  }

  private fun liveStreamNotStarted() {
    liveStreamContainer.gone()
    dfslLoader.gone()
    clStateContainer.visible()
    dlaMessage.text = "Live stream has not been started"
  }

  private fun addSurface() {
    liveStreamContainer.removeAllViews()
    val surface = SurfaceView(requireContext())
    surface.holder.addCallback(surfaceCallback)
    playerView = PlayerView(requireContext())
    playerView.resizeMode = ZOOM
    player = playerView.player
    liveStreamContainer.addView(surface)
    /*val url = viewModel.getLiveStreamUrl()
    println("DyteMobileClient | DyteLiveStreamFragment addSurface $url")
    url?.let {
      player.load(Uri.parse(url))
    }*/
  }
}