package dyte.io.uikit.screens.participant

import android.content.res.ColorStateList
import android.graphics.drawable.GradientDrawable
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.fragment.app.DialogFragment
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import dyte.io.uikit.DyteUIKitBuilder
import dyte.io.uikit.R
import dyte.io.uikit.tokens
import dyte.io.uikit.utils.ViewUtils.gone
import dyte.io.uikit.utils.ViewUtils.visible
import dyte.io.uikit.wiptoken.BorderRadiusToken.BorderRadiusSize
import io.dyte.core.feat.DyteMeetingParticipant
import kotlinx.coroutines.launch

class ParticipantHostControlsBottomsheet(private val dyteMeetingParticipant: DyteMeetingParticipant) :
  BottomSheetDialogFragment() {

  private val meeting by lazy {
    DyteUIKitBuilder.dyteUIKit.meeting
  }

  override fun onCreateView(
    inflater: LayoutInflater, container: ViewGroup?,
    savedInstanceState: Bundle?
  ): View {
    return inflater.inflate(R.layout.fragment_participant_host_controls, container, false)
  }

  override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
    super.onViewCreated(view, savedInstanceState)

    val hostContainer = view.findViewById<View>(R.id.rlHostContainer)
    val shape = GradientDrawable()
    shape.setColor(tokens.colors.background.shade900)
    val radius = tokens.borderRadius.getRadius(
      BorderRadiusSize.TWO,
      requireContext().resources.displayMetrics.density
    )
    shape.cornerRadii = floatArrayOf(radius, radius, radius, radius, 0f, 0f, 0f, 0f)
    hostContainer.background = shape

    // rlParticipantContainer.setBackgroundColor(uiTokens.colors.background.shade900)
    view.findViewById<TextView>(R.id.tvParticipantName).text = dyteMeetingParticipant.name

    val audioView = view.findViewById<View>(R.id.rlAudio)
    if (meeting.localUser.permissions.host.canMuteAudio) {
      audioView.visible()
      audioView.setOnClickListener {
          dyteMeetingParticipant.disableAudio()
          dismiss()
      }
    } else {
      audioView.gone()
    }

    val videoView = view.findViewById<View>(R.id.rlVideo)
    if (meeting.localUser.permissions.host.canMuteVideo) {
      videoView.visible()
      videoView.setOnClickListener {
          dyteMeetingParticipant.disableVideo()
          dismiss()
      }
    } else {
      videoView.gone()
    }

    val kickView = view.findViewById<View>(R.id.rlKick)
    if (meeting.localUser.permissions.host.canKickParticipant) {
      view.findViewById<TextView>(R.id.tvKick).setTextColor(tokens.colors.status.danger)
      view.findViewById<ImageView>(R.id.ivKick).imageTintList =
        ColorStateList.valueOf(tokens.colors.status.danger)
      kickView.visible()
      kickView.setOnClickListener {
          dyteMeetingParticipant.kick()
          dismiss()
      }
    } else {
      kickView.gone()
    }

    val pinView = view.findViewById<View>(R.id.rlPin)
    if (meeting.localUser.permissions.host.canPinParticipant) {
      pinView.visible()
      val tvPin = view.findViewById<TextView>(R.id.tvPin)
      val ivPin = view.findViewById<ImageView>(R.id.ivPin)
      if (dyteMeetingParticipant.isPinned) {
        tvPin.text = "Unpin"
        ivPin.setImageResource(R.drawable.ic_unpin)
      } else {
        tvPin.text = "Pin"
        ivPin.setImageResource(R.drawable.ic_pin)
      }
      pinView.setOnClickListener {
          if (dyteMeetingParticipant.isPinned) {
            dyteMeetingParticipant.unpin()
          } else {
            dyteMeetingParticipant.pin()
          }
          dismiss()
      }
    } else {
      pinView.gone()
    }

    view.findViewById<View>(R.id.rlCancel).setOnClickListener {
      dismiss()
    }
  }

  override fun onCreate(savedInstanceState: Bundle?) {
    setStyle(DialogFragment.STYLE_NORMAL, R.style.AppBottomSheetDialogTheme)
    super.onCreate(savedInstanceState)
  }
}