package dyte.io.uikit.screens.plugins

import android.app.Dialog
import android.content.res.Resources
import android.graphics.drawable.GradientDrawable
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.ImageButton
import android.widget.ImageView
import android.widget.TextView
import androidx.fragment.app.DialogFragment
import androidx.recyclerview.widget.RecyclerView
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import dyte.io.uikit.DyteUIKitBuilder
import dyte.io.uikit.R
import dyte.io.uikit.R.dimen
import dyte.io.uikit.R.layout
import dyte.io.uikit.tokens
import dyte.io.uikit.utils.RVItemVerticalDecoration
import dyte.io.uikit.wiptoken.BorderRadiusToken.BorderRadiusSize
import dyte.io.uikit.wiptoken.DyteUITokens
import io.dyte.core.listeners.DytePluginEventsListener
import io.dyte.core.feat.DytePlugin
import kotlinx.coroutines.launch

class DytePluginsBottomSheet : BottomSheetDialogFragment() {
  private lateinit var pluginsRecyclerView: RecyclerView
  private lateinit var pluginListAdapter: PluginListAdapter
  private lateinit var noPluginsTextView: TextView

  private val meeting by lazy {
    DyteUIKitBuilder.dyteUIKit.meeting
  }

  private val pluginEventsListener = object : DytePluginEventsListener {
    override fun onPluginActivated(plugin: DytePlugin) {
      super.onPluginActivated(plugin)
      refreshList()
    }

    override fun onPluginDeactivated(plugin: DytePlugin) {
      super.onPluginDeactivated(plugin)
      refreshList()
    }

    override fun onPluginFileRequest(plugin: DytePlugin) {
      // no-op
    }
  }

  override fun onCreateView(
    inflater: LayoutInflater, container: ViewGroup?,
    savedInstanceState: Bundle?
  ): View {
    return inflater.inflate(layout.bottom_sheet_plugins, container, false)
  }

  override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
    val dialog = super.onCreateDialog(savedInstanceState)

    dialog.setOnShowListener {
      val bottomSheet: FrameLayout = (dialog as BottomSheetDialog)
        .findViewById(com.google.android.material.R.id.design_bottom_sheet)
        ?: return@setOnShowListener

      val behavior = BottomSheetBehavior.from(bottomSheet)
      behavior.state = BottomSheetBehavior.STATE_EXPANDED
      behavior.skipCollapsed = true

      // val layoutParams = bottomSheet.layoutParams
      // layoutParams.height = Resources.getSystem().displayMetrics.heightPixels
      // bottomSheet.layoutParams = layoutParams
    }
    return dialog
  }

  override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
    super.onViewCreated(view, savedInstanceState)
    (requireDialog() as BottomSheetDialog).dismissWithAnimation = true

    val shape = GradientDrawable()
    shape.setColor(tokens.colors.background.shade900)
    val radius = tokens.borderRadius.getRadius(BorderRadiusSize.TWO, requireContext().resources.displayMetrics.density)
    shape.cornerRadii = floatArrayOf(radius, radius, radius, radius, 0f, 0f, 0f, 0f)
    view.findViewById<View>(R.id.clPluginsContainer).background = shape

    setUpHeader(view)
    setUpChildViews(view)
    meeting.addPluginEventsListener(pluginEventsListener)
    refreshList()
  }

  private fun setUpHeader(view: View) {
    view.findViewById<TextView>(R.id.header_text_view_title).text = "Plugins"
    view.findViewById<ImageView>(R.id.header_button_close).setOnClickListener {
      dismiss()
    }
  }

  private fun setUpChildViews(view: View) {
    pluginsRecyclerView = view.findViewById(R.id.plugins_recycler_view)
    noPluginsTextView = view.findViewById(R.id.plugins_text_view_no_plugins)

    pluginListAdapter = PluginListAdapter { plugin ->
        if (plugin.isActive) {
          plugin.deactivate {

          }
        } else {
          plugin.activate {

          }
        }
        dismiss()
    }
    pluginsRecyclerView.adapter = pluginListAdapter
    pluginsRecyclerView.addItemDecoration(
      RVItemVerticalDecoration(resources.getDimensionPixelSize(dimen.dyte_vertical_spacing_16))
    )
  }

  private fun refreshList() {
    val plugins = meeting.plugins.all
    if (plugins.isNotEmpty()) {
      noPluginsTextView.visibility = View.GONE
      pluginsRecyclerView.visibility = View.VISIBLE
      pluginListAdapter.submitList(ArrayList(plugins))
    } else {
      noPluginsTextView.visibility = View.VISIBLE
      pluginsRecyclerView.visibility = View.GONE
    }
  }

  override fun onCreate(savedInstanceState: Bundle?) {
    setStyle(DialogFragment.STYLE_NORMAL, R.style.AppBottomSheetDialogTheme)
    super.onCreate(savedInstanceState)
  }
}