package dyte.io.uikit.screens.polls

import android.app.Dialog
import android.content.res.Resources
import android.graphics.drawable.GradientDrawable
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.CheckBox
import android.widget.EditText
import android.widget.FrameLayout
import android.widget.ImageButton
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.fragment.app.DialogFragment
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import dyte.io.uikit.DyteUIKitBuilder
import dyte.io.uikit.R
import dyte.io.uikit.atoms.DyteCheckBoxAtom
import dyte.io.uikit.atoms.DyteInputFieldAtom
import dyte.io.uikit.tokens
import dyte.io.uikit.utils.ViewUtils.setBackground
import dyte.io.uikit.wiptoken.BorderRadiusToken.BorderRadiusSize
import dyte.io.uikit.wiptoken.DyteUITokens
import kotlinx.coroutines.launch

class CreatePollBottomSheet : BottomSheetDialogFragment() {
  private lateinit var pollQuestionInputField: DyteInputFieldAtom
  private lateinit var pollOptionsContainer: LinearLayout
  private lateinit var anonymousPollCheckBox: DyteCheckBoxAtom
  private lateinit var hideResultCheckBox: DyteCheckBoxAtom
  private lateinit var createPollButton: Button
  private lateinit var addPollOptionButton: Button

  override fun onCreate(savedInstanceState: Bundle?) {
    setStyle(DialogFragment.STYLE_NORMAL, R.style.AppBottomSheetDialogTheme)
    super.onCreate(savedInstanceState)
  }

  override fun onCreateView(
    inflater: LayoutInflater, container: ViewGroup?,
    savedInstanceState: Bundle?
  ): View {
    return inflater.inflate(R.layout.bottom_sheet_create_poll, container, false)
  }

  override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
    super.onViewCreated(view, savedInstanceState)
    (requireDialog() as BottomSheetDialog).dismissWithAnimation = true

    val shape = GradientDrawable()
    shape.setColor(tokens.colors.background.shade900)
    val radius = tokens.borderRadius.getRadius(BorderRadiusSize.TWO, requireContext().resources.displayMetrics.density)
    shape.cornerRadii = floatArrayOf(radius, radius, radius, radius, 0f, 0f, 0f, 0f)
    view.findViewById<View>(R.id.clCreateBottomsheet).background = shape

    setUpHeader(view)
    setUpChildViews(view)

    setupTokenForOptions()
  }

  override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
    val dialog = super.onCreateDialog(savedInstanceState)

    dialog.setOnShowListener {
      val bottomSheet: FrameLayout = (dialog as BottomSheetDialog)
        .findViewById(com.google.android.material.R.id.design_bottom_sheet)
        ?: return@setOnShowListener

      val behavior = BottomSheetBehavior.from(bottomSheet)
      behavior.state = BottomSheetBehavior.STATE_EXPANDED
      behavior.skipCollapsed = true
      behavior.peekHeight
    }
    return dialog
  }

  private fun setUpHeader(view: View) {
    view.findViewById<TextView>(R.id.header_text_view_title).text = "Create Poll"
    view.findViewById<ImageView>(R.id.header_button_close).setOnClickListener {
      dismiss()
    }
  }

  private fun setUpChildViews(view: View) {
    pollQuestionInputField = view.findViewById(R.id.create_poll_edit_text_question)
    pollOptionsContainer = view.findViewById(R.id.create_poll_options_container)
    anonymousPollCheckBox = view.findViewById(R.id.create_poll_checkbox_anonymous)
    hideResultCheckBox = view.findViewById(R.id.create_poll_checkbox_hide_result)
    createPollButton = view.findViewById(R.id.create_poll_button)
    addPollOptionButton = view.findViewById(R.id.create_poll_button_add_option)

    addPollOptionButton.setBackground(tokens.borderRadius, tokens.colors.background.shade700)
    addPollOptionButton.setTextColor(tokens.colors.text.onBackground.shade600)

    pollQuestionInputField.setBackground(tokens.borderRadius, tokens.colors.background.shade800)

    createPollButton.setOnClickListener {
      onCreatePollButtonClicked()
    }

    addPollOptionButton.setOnClickListener {
      onAddPollOptionButtonClicked()
    }
  }

  private fun onAddPollOptionButtonClicked() {
    val pollOptionView = LayoutInflater.from(requireContext())
      .inflate(R.layout.item_create_poll_option, pollOptionsContainer, false)
    pollOptionView.findViewById<View>(R.id.create_poll_option_button_remove)
      .setOnClickListener {
        try {
          pollOptionsContainer.removeView(pollOptionView)
        } catch (e: Exception) {

        }
      }
    val pollOptionEdittext = pollOptionView.findViewById<DyteInputFieldAtom>(R.id.create_poll_option_edit_text)
    pollOptionEdittext.setBackground(tokens.borderRadius, tokens.colors.background.shade800)
    pollOptionEdittext.setTextColor(tokens.colors.text.onBackground.shade1000)
    pollOptionEdittext.setHintTextColor(tokens.colors.text.onBackground.shade1000)
    pollOptionsContainer.addView(pollOptionView)
  }

  private fun onCreatePollButtonClicked() {
    val question = pollQuestionInputField.text.toString()
    val options = getPollOptions()
    val isAnonymousPoll = anonymousPollCheckBox.isChecked
    val hideResultBeforeVoting = hideResultCheckBox.isChecked

    try {
        DyteUIKitBuilder.dyteUIKit.meeting.polls
          .create(question, options, isAnonymousPoll, hideResultBeforeVoting)
        dismiss()
    } catch (e: Exception) {
      e.printStackTrace()
    }
  }

  private fun setupTokenForOptions() {
    for (i in 0 until pollOptionsContainer.childCount) {
      val childView = pollOptionsContainer.getChildAt(i)
      when (childView) {
        is EditText -> {
          childView.setBackground(tokens.borderRadius, tokens.colors.background.shade800)
          childView.setTextColor(tokens.colors.text.onBackground.shade1000)
          childView.setHintTextColor(tokens.colors.text.onBackground.shade1000)
        }
      }
    }
  }

  private fun getPollOptions(): List<String> {
    val options = mutableListOf<String>()
    for (i in 0 until pollOptionsContainer.childCount) {
      val childView = pollOptionsContainer.getChildAt(i)
      when (childView) {
        is EditText -> {
          options.add(childView.text.toString())
        }
        is LinearLayout -> {
          val editText = childView.findViewById<EditText>(R.id.create_poll_option_edit_text)
          options.add(editText.text.toString())
        }
      }
    }
    return options
  }
}