package dyte.io.uikit.screens.settings

import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import dyte.io.uikit.DyteUIKitBuilder
import dyte.io.uikit.states.AudioState
import dyte.io.uikit.states.VideoState
import io.dyte.core.models.DyteAudioDevice
import io.dyte.core.models.DyteVideoDevice

class DyteSettingsViewModel: ViewModel() {
  val audioStateLiveData = MutableLiveData<AudioState>()
  val videoStateLiveData = MutableLiveData<VideoState>()

  var videoDevices = listOf<DyteVideoDevice>()
  var audioDevices = listOf<DyteAudioDevice>()

  lateinit var selectedVideoDevice : DyteVideoDevice
  lateinit var selectedAudioDevice : DyteAudioDevice

  private val meeting by lazy {
    DyteUIKitBuilder.meeting
  }

  fun start() {
    if (meeting.localUser.isMicrophonePermissionGranted && meeting.localUser.permissions.media.canPublishAudio) {
      loadAudioDevices()
      audioStateLiveData.value = AudioState.AudioEnabled(meeting.localUser.getSelectedAudioDevice())
    } else {
      audioStateLiveData.value = AudioState.AudioBlocked
    }

    if (meeting.localUser.isCameraPermissionGranted && meeting.localUser.permissions.media.canPublishVideo) {
      loadVideoDevices()
      videoStateLiveData.value = VideoState.VideoEnabled(meeting.localUser.getSelectedVideoDevice())
    } else {
      videoStateLiveData.value = VideoState.VideoBlocked
    }
  }

  private fun loadAudioDevices() {
    audioDevices = meeting.localUser.getAudioDevices().toList()
    selectedAudioDevice = meeting.localUser.getSelectedAudioDevice()
  }
  private fun loadVideoDevices() {
    videoDevices = meeting.localUser.getVideoDevices().toList()
    selectedVideoDevice = meeting.localUser.getSelectedVideoDevice()
  }


  fun setVideoDevice(dyteVideoDevice: DyteVideoDevice) {
    meeting.localUser.setVideoDevice(dyteVideoDevice)
  }

  fun setAudioDevice(dyteAudioDevice: DyteAudioDevice) {
    meeting.localUser.setAudioDevice(dyteAudioDevice)
  }
}