package dyte.io.uikit.utils

import android.graphics.Rect
import android.graphics.drawable.GradientDrawable
import android.view.View
import androidx.recyclerview.widget.RecyclerView
import dyte.io.uikit.wiptoken.BorderRadiusToken
import dyte.io.uikit.wiptoken.BorderRadiusToken.BorderRadiusSize

object ViewUtils {
  fun View.visible() {
    this.visibility = View.VISIBLE
  }

  fun View.gone() {
    this.visibility = View.GONE
  }

  fun View.invisible() {
    this.visibility = View.INVISIBLE
  }


  fun View.goneAnimate() {
    animate().alpha(0.0f)
  }

  fun View.visibleAnimate() {
    animate().alpha(1.0f)
  }

  fun View.setBackground(radiusToken: BorderRadiusToken, color: Int) {
    val shape = GradientDrawable()
    shape.cornerRadius = radiusToken.getRadius(BorderRadiusSize.ONE, displayDensity)
    shape.setColor(color)
    background = shape
  }
}

internal class RVItemVerticalDecoration(private val spacing: Int) : RecyclerView.ItemDecoration() {
  override fun getItemOffsets(
    outRect: Rect, view: View,
    parent: RecyclerView, state: RecyclerView.State
  ) {
    with(outRect) {
      if (parent.getChildAdapterPosition(view) == 0) {
        top = spacing
      }
      bottom = spacing
    }
  }
}