package dyte.io.uikit.view

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import android.view.Gravity
import android.widget.ImageView
import android.widget.ImageView.ScaleType.CENTER
import android.widget.LinearLayout
import dyte.io.uikit.R
import dyte.io.uikit.designtokens.TokenRepo
import dyte.io.uikit.utils.Utils.px

/**
 * Dyte icon button view
 *
 * Android View implementation to render [MeetingComponent.IconButton]
 * Depending on type of button renders appropriate view on ImageView.
 * Also adds a click listener and performs action depending upon [dyte.io.uikit.DyteIconButtonType]
 *
 * Shown to image view type buttons.
 * Click is also handelled here only.
 */
class DyteIconButtonView : LinearLayout {

  private lateinit var ivLogo: ImageView
  lateinit var llImageButtonContainer: LinearLayout

  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    inflate(context, R.layout.button_view, this)
    ivLogo = findViewById(R.id.ivLogo)
    llImageButtonContainer = findViewById(R.id.llImageContainer)
    setBackgroundOnImage()
  }

  private fun setBackgroundOnImage() {

    val shape = GradientDrawable()
    shape.cornerRadius = TokenRepo.getBorderRadiusRepo().getBorderRadius(2).px.toFloat()
    llImageButtonContainer.background = shape
    gravity = Gravity.CENTER_HORIZONTAL

    ivLogo.scaleType = CENTER
    ivLogo.setColorFilter(
      TokenRepo.getColorRepo().getIconColor(),
      android.graphics.PorterDuff.Mode.SRC_IN
    )

    val layoutParams = ivLogo.layoutParams
    layoutParams.height = 32.px
    layoutParams.width = 32.px
    ivLogo.layoutParams = layoutParams
  }

  /*fun refresh(
    buttonComponent: MeetingComponent.IconButton,
    tokenRepo: TokenRepoType, dyteAndroidClient: DyteMobileClient, stateManager: StateManager
  ) {
    this.stateManager = stateManager

    val imageRes = when (buttonComponent.dyteIconType) {
      PARTICIPANT_LIST -> {
        drawable.ic_baseline_people_24
      }
      CHAT -> {
        drawable.ic_baseline_chat_24
      }
      PLUGINS -> {
        drawable.ic_baseline_poll_24
      }
      SWITCH_CAMERA -> {
        drawable.ic_baseline_switch_camera_24
      }
      is AudioToggle -> {
        ivLogo.setColorFilter(tokenRepo.getColorRepo().getStatusColorDanger())
        drawable.ic_mic_off
      }
      is VideoToggle -> {
        ivLogo.setColorFilter(tokenRepo.getColorRepo().getStatusColorDanger())
        drawable.ic_video_off
      }
      AUDIO_TRACK_SELECTOR -> {
        drawable.ic_baseline_audiotrack_24
      }
      END_CALL -> {
        ivLogo.setColorFilter(tokenRepo.getColorRepo().getStatusColorDanger())
        drawable.ic_baseline_call_end_24
      }
      SETTINGS -> {
        drawable.ic_setting
      }
      SCREEN_SHARE -> {
        drawable.ic_baseline_screen_share_24
      }
      OPEN_OPTION -> {
        drawable.ic_up_arrow
      }
    }


    ivLogo.setImageResource(imageRes)

    *//*llImageButtonContainer.setOnClickListener {
      Log.v("DyteEventLogger", "onButtonClick ${buttonComponent.dyteIconType}")
      when (buttonComponent.dyteIconType) {
        PARTICIPANT_LIST -> {
          stateManager.stateUpdate(StateType.ParticipantOpen)
        }
        CHAT -> {
          stateManager.stateUpdate(StateType.ChatOpen)
        }
        PLUGINS -> {
        }
        SWITCH_CAMERA -> {
          DyteClientHelper.meeting.self.switchCamera()
        }
        is AudioToggle -> {
          if (DyteClientHelper.meeting.self.audioEnabled) {
            ivLogo.setImageResource(R.drawable.ic_mic)
            ivLogo.setColorFilter(tokenRepo.getColorRepo().getIconColor())
            DyteClientHelper.meeting.self.disableAudio()
          } else {
            ivLogo.setImageResource(R.drawable.ic_mic_off)
            ivLogo.setColorFilter(tokenRepo.getColorRepo().getStatusColorDanger())
            DyteClientHelper.meeting.self.enableAudio()
          }
        }
        is VideoToggle -> {
          if (DyteClientHelper.meeting.self.videoEnabled) {
            ivLogo.setImageResource(drawable.ic_video)
            ivLogo.setColorFilter(tokenRepo.getColorRepo().getIconColor())
            DyteClientHelper.meeting.self.disableVideo()
          } else {
            ivLogo.setImageResource(drawable.ic_video_off)
            ivLogo.setColorFilter(tokenRepo.getColorRepo().getStatusColorDanger())
            DyteClientHelper.meeting.self.enableVideo()
          }
        }
        SETTINGS -> TODO()
        AUDIO_TRACK_SELECTOR -> TODO()
        SCREEN_SHARE -> TODO()
        END_CALL -> {
          DyteClientHelper.meeting.leaveRoom()
        }
        OPEN_OPTION -> {
          stateManager.stateUpdate(StateType.MeetingOption)
        }
      }
    }*//*
  }*/
}