package dyte.io.uikit.view

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import android.view.Gravity
import android.widget.ImageView
import android.widget.ImageView.ScaleType.CENTER
import android.widget.LinearLayout
import dyte.io.uikit.R
import dyte.io.uikit.designtokens.TokenRepo
import dyte.io.uikit.utils.Utils.px

/**
 * Dyte icon button view
 *
 * Android View implementation to render [MeetingComponent.IconButton]
 * Depending on type of button renders appropriate view on ImageView.
 * Also adds a click listener and performs action depending upon [dyte.io.uikit.DyteIconButtonType]
 *
 * Shown to image view type buttons.
 * Click is also handelled here only.
 */
class DyteIconMicView : LinearLayout {

  lateinit var ivLogo: ImageView
  lateinit var llImageButtonContainer: LinearLayout
  private var isAudioEnabled = true

  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  fun setListener(
    onAudioToggle: (isEnabled: Boolean) -> Unit
  ) {
    llImageButtonContainer.setOnClickListener {
      isAudioEnabled = !isAudioEnabled
      onAudioToggle.invoke(isAudioEnabled)
      if (isAudioEnabled) {
        ivLogo.setImageResource(R.drawable.ic_mic)
      } else {
        ivLogo.setImageResource(R.drawable.ic_mic_off)
      }
    }
  }

  private fun init() {
    inflate(context, R.layout.send_view, this)
    ivLogo = findViewById(R.id.ivLogo)
    llImageButtonContainer = findViewById(R.id.llImageContainer)
    setBackgroundOnImage()

    val imgRes = R.drawable.ic_mic
    ivLogo.setImageResource(imgRes)
  }

  private fun setBackgroundOnImage() {
    val shape = GradientDrawable()
    shape.setColor(TokenRepo.getColorRepo().getBrandColor())
    refresh()
  }

  fun refresh() {
    ivLogo.layoutParams.height = 48.px
    ivLogo.layoutParams.width = 48.px
    ivLogo.isClickable = false

    val shape = GradientDrawable()
    shape.cornerRadius = TokenRepo.getBorderRadiusRepo().getBorderRadius(2).px.toFloat()
    shape.setColor(TokenRepo.getColorRepo().getVideoBackGroundColor())
    ivLogo.setColorFilter(TokenRepo.getColorRepo().getIconColor())
    llImageButtonContainer.background = shape
    llImageButtonContainer.gravity = Gravity.CENTER
    ivLogo.scaleType = CENTER

    // if (DyteClientHelper.dyteClient.getSelf().audioEnabled){
    //   shape.setColor(TokenRepo.getColorRepo().getVideoBackGroundColor())
    // }else{
    //   shape.setColor(TokenRepo.getColorRepo().getStatusColorDanger())
    // }
  }
}

