package dyte.io.uikit.view

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import android.view.Gravity
import android.widget.ImageView
import android.widget.ImageView.ScaleType.CENTER
import android.widget.LinearLayout
import dyte.io.uikit.R
import dyte.io.uikit.designtokens.TokenRepo
import dyte.io.uikit.utils.Utils.px

/**
 * Dyte icon button view
 *
 * Android View implementation to render [MeetingComponent.IconButton]
 * Depending on type of button renders appropriate view on ImageView.
 * Also adds a click listener and performs action depending upon [dyte.io.uikit.DyteIconButtonType]
 *
 * Shown to image view type buttons.
 * Click is also handelled here only.
 */
class DyteIconSendView : LinearLayout {

  private lateinit var ivLogo: ImageView
  private lateinit var llImageButtonContainer: LinearLayout

  var clickAction: ((button: DyteIconSendView) -> Any?)? = null

  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    inflate(context, R.layout.send_view, this)
    ivLogo = findViewById(R.id.ivLogo)
    llImageButtonContainer = findViewById(R.id.llImageContainer)
    setBackgroundOnImage()
    llImageButtonContainer.setOnClickListener {
      this.clickAction?.let {
        it(this)
      }
    }
  }

  private fun setBackgroundOnImage() {

    val shape = GradientDrawable()
    shape.cornerRadius = TokenRepo.getBorderRadiusRepo().getBorderRadius(2).px.toFloat()

    shape.setColor(TokenRepo.getColorRepo().getBrandColor())

    val strokeColor = TokenRepo.getColorRepo().getBrandColor()
    shape.setStroke(
      TokenRepo.getBorderWidthRepo().getBorderWidth(2).px.toFloat().toInt(),
      strokeColor
    )

    refresh()
  }

  fun refresh() {
    val tokenRepo = TokenRepo

    ivLogo.scaleType = CENTER
    ivLogo.setColorFilter(
      tokenRepo.getColorRepo().getIconColor(),
      android.graphics.PorterDuff.Mode.SRC_IN
    )

    ivLogo.isClickable = false

    val imgRes = R.drawable.ic_baseline_send_24

    ivLogo.setImageResource(imgRes)

    val shape = GradientDrawable()
    shape.cornerRadius = tokenRepo.getBorderRadiusRepo().getBorderRadius(2).px.toFloat()

    shape.setColor(tokenRepo.getColorRepo().getBrandColor())

    val strokeColor = tokenRepo.getColorRepo().getBrandColor()
    shape.setStroke(
      tokenRepo.getBorderWidthRepo().getBorderWidth(2).px.toFloat().toInt(),
      strokeColor
    )

    val layoutParams = ivLogo.layoutParams
    layoutParams.height = 32.px
    layoutParams.width = 32.px
    ivLogo.layoutParams = layoutParams

    llImageButtonContainer.background = shape
    gravity = Gravity.CENTER_HORIZONTAL
  }
}

