package dyte.io.uikit.view

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import android.view.Gravity
import android.widget.ImageView
import android.widget.ImageView.ScaleType.CENTER
import android.widget.LinearLayout
import dyte.io.uikit.R
import dyte.io.uikit.designtokens.TokenRepo
import dyte.io.uikit.utils.Utils.px
import org.webrtc.VideoTrack

/**
 * Dyte icon button view
 *
 * Android View implementation to render [MeetingComponent.IconButton]
 * Depending on type of button renders appropriate view on ImageView.
 * Also adds a click listener and performs action depending upon [dyte.io.uikit.DyteIconButtonType]
 *
 * Shown to image view type buttons.
 * Click is also handelled here only.
 */
class DyteIconVideoView : LinearLayout {

  lateinit var ivLogo: ImageView
  lateinit var llImageButtonContainer: LinearLayout
  private var isVideoEnabled = true
  private var videoTrack: VideoTrack? = null

  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    inflate(context, R.layout.send_view, this)
    ivLogo = findViewById(R.id.ivLogo)
    llImageButtonContainer = findViewById(R.id.llImageContainer)
    setBackgroundOnImage()
  }

  fun setListener(
    onVideoToggle: (isEnabled: Boolean) -> Unit,
    videoViewToggle: (videoEnabled: Boolean) -> Unit
  ) {
    llImageButtonContainer.setOnClickListener {

      isVideoEnabled = !isVideoEnabled
      onVideoToggle.invoke(isVideoEnabled)
      if (isVideoEnabled) {
        videoViewToggle.invoke(true)
        ivLogo.setImageResource(R.drawable.ic_video)
      } else {
        videoViewToggle.invoke(false)
        ivLogo.setImageResource(R.drawable.ic_baseline_videocam_off_24)
      }
      videoTrack?.setEnabled(isVideoEnabled)
    }
  }

  private fun setBackgroundOnImage() {

    refresh()
  }

  fun refresh() {

    ivLogo.layoutParams.height = 48.px
    ivLogo.layoutParams.width = 48.px
    ivLogo.isClickable = false
    val imgRes = R.drawable.ic_video
    ivLogo.setImageResource(imgRes)
    val shape = GradientDrawable()
    shape.cornerRadius = TokenRepo.getBorderRadiusRepo().getBorderRadius(2).px.toFloat()
    ivLogo.setColorFilter(TokenRepo.getColorRepo().getIconColor())
    shape.setColor(TokenRepo.getColorRepo().getVideoBackGroundColor())
    llImageButtonContainer.background = shape
    llImageButtonContainer.gravity = Gravity.CENTER
    ivLogo.scaleType = CENTER
    llImageButtonContainer.setOnClickListener {
      /*val videEnabled = DyteClientHelper.meeting.self.videoEnabled
      if (videEnabled) {
        DyteClientHelper.meeting.self.disableVideo()
      } else {
        DyteClientHelper.meeting.self.enableVideo()
      }*/
    }
  }
}

