package dyte.io.uikit.view

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import dyte.io.uikit.R
import dyte.io.uikit.utils.displayDensity
import dyte.io.uikit.wiptoken.BorderRadiusToken.BorderRadiusSize
import dyte.io.uikit.wiptoken.DyteUITokens
import io.dyte.core.DyteMobileClient

class DyteLeaveButton : DyteControlBarButton {
  private var meeting: DyteMobileClient? = null

  override val defaultIconResId: Int
    get() = R.drawable.ic_leave_call_24

  override val defaultLabelResId: Int
    get() = R.string.dyteleavebutton_label

  constructor(context: Context) : super(context)
  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs)
  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  )

  override fun createBackgroundDrawable(uiTokens: DyteUITokens): GradientDrawable {
    val backgroundDrawable = GradientDrawable().apply {
      shape = GradientDrawable.RECTANGLE
      setColor(uiTokens.colors.status.danger)
      cornerRadius = uiTokens.borderRadius.getRadius(BorderRadiusSize.ONE, displayDensity)
    }
    return backgroundDrawable
  }

  /*
  note(swapnil): If the host fragment/activity will handle the DyteLeaveMeetingDialog logic
  then, meeting object will not be needed in this class.
   */
  fun activate(meeting: DyteMobileClient) {
    this.meeting = meeting
  }

  override fun onDetachedFromWindow() {
    meeting = null
    super.onDetachedFromWindow()
  }
}