package dyte.io.uikit.view

import android.content.Context
import android.util.AttributeSet
import android.view.View
import androidx.core.content.ContextCompat
import dyte.io.uikit.R
import io.dyte.core.DyteMobileClient
import io.dyte.core.listeners.DyteSelfEventsListener

class DyteMicToggleButton : DyteControlBarButton {
  private var meeting: DyteMobileClient? = null

  override val defaultIconResId: Int
    get() = R.drawable.ic_mic_on_24

  override val defaultLabelResId: Int
    get() = R.string.dytemictogglebutton_on_state_label

  private val selfAudioEventsListener = object : DyteSelfEventsListener {
    override fun onAudioUpdate(audioEnabled: Boolean) {
      super.onAudioUpdate(audioEnabled)
      updateState()
    }
  }

  private val onClickListener = MicToggleOnClickListener()

  constructor(context: Context) : super(context)
  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs)
  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  )

  fun activate(meeting: DyteMobileClient) {
    this.meeting = meeting
    this.meeting?.addSelfEventsListener(selfAudioEventsListener)
    setOnClickListener(onClickListener)
    updateState()
  }

  override fun setOnClickListener(listener: OnClickListener?) {
    if ((listener is MicToggleOnClickListener) || listener == null) {
      super.setOnClickListener(listener)
    }
  }

  override fun onDetachedFromWindow() {
    super.setOnClickListener(null)
    this.meeting?.removeSelfEventsListener(selfAudioEventsListener)
    super.onDetachedFromWindow()
  }

  private fun updateState() {
    meeting?.let {
      if (it.localUser.audioEnabled) {
        setIconDrawable(ContextCompat.getDrawable(context, R.drawable.ic_mic_on_24))
        setLabelResource(R.string.dytemictogglebutton_on_state_label)
      } else {
        setIconDrawable(ContextCompat.getDrawable(context, R.drawable.ic_mic_off_24))
        setLabelResource(R.string.dytemictogglebutton_off_state_label)
      }
    }
  }

  private fun setLabelResource(stringResId: Int) {
    labelTextView.setText(stringResId)
  }

  private inner class MicToggleOnClickListener : View.OnClickListener {
    override fun onClick(view: View?) {
      meeting?.let {
        if (it.localUser.audioEnabled) {
          it.localUser.disableAudio()
        } else {
          it.localUser.enableAudio()
        }
      }
    }
  }
}